/*
 * Cheops Network User Interface
 *
 * Copyright (C) 1999, Adtran, Inc.
 * 
 * Distributed under the terms of the GNU GPL
 *
 */

#include <gtk/gtk.h>
#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <errno.h>
#include <arpa/inet.h>
#include <string.h>
#include <netdb.h>
#include "cheops.h"

#define MAX_FD 1024		/* Max # of file descriptors */

GtkWidget *status=NULL;
GtkWidget *descriptors=NULL;

static int have_refresh=0;

static void close_status()
{
	if (status) {
		gtk_widget_destroy(status);
		status=NULL;
	}
	gtk_timeout_remove(have_refresh);
}

static void update_desc()
{
	char buf[256];
	int s; int max=0;
	struct sockaddr_in sin;
	int addrlen;
	for (s=0;s<MAX_FD;s++) {
		addrlen = sizeof(sin);
		if ((!getsockname(s, &sin, &addrlen)) || (errno == ENOTSOCK))
			max++;
			
	}
	snprintf(buf, sizeof(buf), "%d  ", max);
	gtk_label_set(GTK_LABEL(descriptors), buf);
}

static void update_status()
{
	update_desc();
}

static int refresh()
{
	update_status();
	return TRUE;
}

static void desc_dump()
{
	int res;
	int s=0;
	struct sockaddr_in sin;
	int addrlen;
	int ret;
	int alen;
	char *t = "unknown";

	fprintf(stderr, "Sockets and File Descriptor Dump\n");
	fprintf(stderr, "================================\n");
	/* Dump location of file descriptors to stderr */
	for (s=0;s<MAX_FD;s++) {
		addrlen = sizeof(sin);
		alen = sizeof(ret);
		res = getsockopt(s, SOL_SOCKET, SO_TYPE, &ret, &alen);
		if (res > -1) {
			printf("ret is %d\n", ret);
			if (ret == SOCK_DGRAM) {
				t = "udp";
			} else if (ret == SOCK_STREAM) {
				t = "tcp";
			} else if (ret == SOCK_RAW) {
				t = "raw";
			}
		}
		res = getsockname(s, &sin, &addrlen);
		if (res > -1) {
			fprintf(stderr, "%d: %s socket from %s:%d", s, t, inet_ntoa(sin.sin_addr), ntohs(sin.sin_port));
			addrlen = sizeof(sin);
			res = getpeername(s, &sin, &addrlen);
			if (res > -1) 
				fprintf(stderr, " to %s:%d\n", inet_ntoa(sin.sin_addr), ntohs(sin.sin_port));
			else
				fprintf(stderr, " to <unconnected>\n");
		} else {
			if (errno == ENOTSOCK) 
				fprintf(stderr, "%d: file descriptor\n", s);
		}	
	}				
}

void show_status()
{
	GtkWidget *table;
	GtkWidget *vbox;
	GtkWidget *bbox;
	GtkWidget *close;
	GtkWidget *label;
	GtkWidget *frame;
	GtkWidget *dump;
	if (status) {
		gtk_widget_show(status);
		return;
	}
	status = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_widget_realize(status);
	gtk_window_set_title(GTK_WINDOW(status), "Cheops Status");
	fix_icon(status->window);
	gtk_signal_connect(GTK_OBJECT(status), "delete_event", close_status, NULL);
	
	vbox = gtk_vbox_new(FALSE, 5);
	gtk_widget_show(vbox);
	table = gtk_table_new(1, 3, FALSE);
	gtk_container_border_width(GTK_CONTAINER(table), 10);
	gtk_widget_show(table);
	frame = gtk_frame_new("Status");
	gtk_widget_show(frame);
	gtk_container_border_width(GTK_CONTAINER(frame), 10);
	gtk_container_add(GTK_CONTAINER(frame), table);
	gtk_box_pack_start(GTK_BOX(vbox), frame, TRUE, TRUE, 5);
	
	label = gtk_label_new("Open File Descriptors: ");
	gtk_widget_show(label);
	descriptors = gtk_label_new("<unknown>");
	gtk_widget_show(descriptors);
	dump = gtk_button_new_with_label("Dump to stderr...");
	gtk_widget_show(dump);
	gtk_signal_connect(GTK_OBJECT(dump), "clicked", desc_dump, NULL);
	gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), descriptors, 1, 2, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), dump, 2, 3, 0, 1);
	
	close = gtk_button_new_with_label("  Close  ");
	gtk_widget_show(close);
	gtk_signal_connect(GTK_OBJECT(close), "clicked", close_status, NULL);
	bbox = gtk_hbox_new(FALSE, 5);
	gtk_widget_show(bbox);
	gtk_box_pack_end(GTK_BOX(bbox), close, FALSE, FALSE, 5);
	gtk_box_pack_start(GTK_BOX(vbox), bbox, FALSE, FALSE, 5);
	gtk_container_add(GTK_CONTAINER(status), vbox);
	update_status();
	gtk_widget_show(status);
	have_refresh = gtk_timeout_add(2000, refresh, NULL);
}
