/*
 * Network Explorer
 *
 * Copyright (C) 1998, Mark Spencer
 * 
 * Distributed under the terms of the GNU GPL
 *
 */
#include <gtk/gtk.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <arpa/inet.h>
#include <pwd.h>
#include "cheops.h"

struct service *users=NULL;

void immediate_setcursor(int c)
{
	GdkCursor *cursor;
	cursor = gdk_cursor_new(GDK_WATCH);
	gdk_window_set_cursor(main_window.window->window, cursor);
	gdk_cursor_destroy(cursor);
	while (gtk_events_pending())
               gtk_main_iteration();
}

void register_service(char *name, int port, char *format, 
                      int (*connect_routine)(struct service *, char *, char *, char *, int),
		      int flags)
{
	struct service *s, *tmp, *prev=NULL;
	/* Setup structure first */
	tmp = g_new(struct service, 1);
	tmp->port = port;
	strncpy(tmp->name, name, sizeof(tmp->name));
	tmp->connect = connect_routine;
	tmp->flags = flags;
	strncpy(tmp->format, format, sizeof(tmp->format));
	
	/* Find our place in the list */
	s = users;	
	while (s && (s->port <= port)) {
		prev = s;
		s=s->next;
	}
	tmp->next=s;
	if (prev)
		prev->next = tmp;
	else
		users = tmp;
}

void unregister_service(struct service *svc)
{
	struct service *s;
	s = users;
	if (s == svc) {
		users = users->next;
		return;
	}
	while(s->next && s->next != svc)
		s=s->next;
	if (s->next) {
		s->next = s->next->next;
		g_free(svc);
	}
}

int generic_connect(struct service *svc, char *hostname, char *ip, char *username, int porti)
{
	char buf[1024];
	char port[40];
	char *s;
	int x=0;
	memset(buf, 0, sizeof(buf));
	s=svc->format;	
	snprintf(port, sizeof(port), "%d", porti);
	while(*s && x < sizeof(buf)) {
		switch(*s) {
		case '%':
			s++;
			switch(*s) {
			case 'i':
				strncat(buf, ip, sizeof(buf) - x);
				x = strlen(buf) - 1;
				break;
			case 'h':
				strncat(buf, hostname, sizeof(buf) - x);
				x = strlen(buf) - 1;
				break;
			case 'u':
				strncat(buf, username, sizeof(buf) - x);
				x = strlen(buf) - 1;
				break;
			case 'p':
				strncat(buf, port, sizeof(buf) - x);
				x = strlen(buf) - 1;
				break;
			case 'x':
				strncat(buf, xterm, sizeof(buf) - x);
				x = strlen(buf) - 1;
				break;
			case '%':
				strncat(buf, "%", sizeof(buf) - x);
				x = strlen(buf) - 1;
				break;
			default:
				if (x < sizeof(buf) - 2) {
					buf[x++]='%';
					buf[x]=*s;
				}
			}
			break;
		default:
			buf[x]=*s;
		}
		x++;
		s++;
	}
	if (x > sizeof(buf) - 3)
		x -= 3;
	buf[x++]='&';
	return system(buf);
}
int vnc_connect(struct service *svc, char *hostname, char *ip, char *username, int porti)
{
	return generic_connect(svc, hostname, ip, username, porti - 5900);
}
static int load_file(char *filename)
{
	FILE *f;
	char buf[512];
	char *name, *port, *format, *type;
	int flags;
	f=fopen(filename, "r");
	if (!f)
		return 0;
	while (!feof(f)) {
		fgets(buf, sizeof(buf), f);
		if (!feof(f)) {
			flags=0;
			name = strtok(buf, "!");
			if (!name) continue;
			name++;
			port = strtok(NULL, "!");
			if (!port) continue;
			format = strtok(NULL, "!");
			if (!format) continue;
			type = strtok(NULL, "!");
			if (!type) continue;
			if (!strtok(type, "]")) continue;
			if (strstr(format, "%u"))
				flags |= FLAG_USERNAME;
			if (!strcasecmp(type, "vnc")) 
				register_service(name, atoi(port), format, vnc_connect,flags);
			else
				register_service(name, atoi(port), format, generic_connect, flags);
		}
	}
	fclose(f);
	return 1;
}

void init_services()
{
	char *tf, fn[256];
	struct service *s, *s2;;
	
	s = users;
	while(s) {
		s2=s;
		s=s->next;
		g_free(s2);
	}
	users=NULL;
	
	if (getenv("HOME")) {
		snprintf(fn, sizeof(fn), "%s/.cheops-svcs", getenv("HOME"));
		if (load_file(fn))
			return;
	}
	tf = find_file("services.conf");
	if (tf)
		if (load_file(tf))
			return;
	fprintf(stderr, "Unable to locate services.conf!\n");
	return;
}

void save_services()
{
	struct service *s;
	FILE *f;
	char fn[256];
	if (!getenv("HOME"))
		return;
	snprintf(fn, sizeof(fn), "%s/.cheops-svcs", getenv("HOME"));
	f = fopen(fn, "w");
	if (!f)
		return;
	s = users;
	while(s) {
		fprintf(f, "[%s!%d!%s!%s]\n", s->name, s->port, s->format, 
		( s->connect == vnc_connect ? "vnc" : "standard" ));
		s=s->next;
	}
}

static void submit_username(GtkWidget *w, struct service *s)
{
	struct net_object *no;
	struct in_addr ia;
	char *username;
	username = gtk_entry_get_text(GTK_ENTRY(w));
	no = (struct net_object *)gtk_object_get_user_data(GTK_OBJECT(w));
	ia.s_addr = no->ip_addr;	
	gtk_widget_destroy(w->parent->parent);
	if (s->connect(s, no->hostname, inet_ntoa(ia), username, s->port) < 0)
		fprintf(stderr, "service '%s' failed to launch\n", s->name);
}

static void show_username(struct service *s, struct net_object *no)
{
	GtkWidget *window;
	GtkWidget *vbox;
	GtkWidget *label;
	GtkWidget *entry;
	struct passwd *pw;
	char buf[256];
	window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_widget_realize(window);
	fix_icon(window->window);
	entry = gtk_entry_new();
	pw = getpwuid(getuid());
	if (pw) {
		gtk_entry_set_text(GTK_ENTRY(entry), pw->pw_name);
		gtk_entry_select_region(GTK_ENTRY(entry), 0, -1);
	}
	vbox = gtk_vbox_new(FALSE, 5);
	snprintf(buf, sizeof(buf), "Enter username for %s\n",no->hostname);
	label = gtk_label_new(buf);
	gtk_widget_show(entry);
	gtk_widget_show(label);
	gtk_widget_show(vbox);
	gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, FALSE, 5);
	gtk_box_pack_start(GTK_BOX(vbox), entry, FALSE, FALSE, 5);
	gtk_container_add(GTK_CONTAINER(window), vbox);
	gtk_container_border_width(GTK_CONTAINER(window), 10);
	gtk_object_set_user_data(GTK_OBJECT(entry), no);
	gtk_signal_connect(GTK_OBJECT(entry),
			  "activate",
			  GTK_SIGNAL_FUNC(submit_username), 
			  s);
	gtk_signal_connect(GTK_OBJECT(window), "delete_event",
			   GTK_SIGNAL_FUNC(gtk_widget_destroy),
			   window);
	gtk_window_set_title(GTK_WINDOW(window), "Username");
	gtk_widget_grab_focus(entry);
	gtk_widget_show(window);
}

static void service_menu(GtkWidget *w, struct service *s)
{
	struct net_object *no;
	struct in_addr ia;
	no = (struct net_object *)gtk_object_get_user_data(GTK_OBJECT(w));
	gtk_widget_destroy(w->parent);
	if (s->flags & FLAG_USERNAME) {
		show_username(s, no);
	} else {
		ia.s_addr = no->ip_addr;
		if (s->connect(s, no->hostname, inet_ntoa(ia), "", s->port) < 0)
			fprintf(stderr, "service '%s' failed to launch\n", s->name);
	}
}

static void detect_object(GtkWidget *w, struct net_object *no)
{
	struct net_page *np;
	np = (struct net_page *)gtk_object_get_user_data(GTK_OBJECT(no->eventbox->parent));
	examine_host_queue(no->ip_addr, try_ports[0], np); 
}

static void scan_object(GtkWidget *w, struct net_object *no)
{
	struct net_page *np;
	np = (struct net_page *)gtk_object_get_user_data(GTK_OBJECT(no->eventbox->parent));
	port_scanner(no);
}

static void map_object(GtkWidget *w, struct net_object *no)
{
	start_mapping(no);
}

void show_service_menu(struct net_object *no, GdkEventButton *event)
{
	GtkWidget *menu;
	GtkWidget *menuitem;
	struct in_addr me;
	struct port *p1=NULL, *p2;
	struct service *s;
	menu = gtk_menu_new();
	if (option_port_scan) {
		s = users;
		while(s) {
			if (s->port) {
				p2 = g_new(struct port, 1);
				p2->next = p1;
				p2->dport = s->port;
				p2->avail = -1;
				p2->sport = 0;
				p2->svc = s;
				p1 = p2;
			} 
			s=s->next;
		}
		me = getlocalip(no->ip_addr);
		/* Wait up to 3 seconds for replies to come in */
		immediate_setcursor(GDK_WATCH);
		scan_ports(me.s_addr, no->ip_addr, p1, 3);
		gdk_window_set_cursor(main_window.window->window, NULL);
		while(p1) {
			p2 = p1;
			p1=p1->next;
			if (p2->avail>0) {
				menuitem = gtk_menu_item_new_with_label(p2->svc->name);
				gtk_menu_prepend(GTK_MENU(menu), menuitem);
				gtk_widget_show(menuitem);
				gtk_object_set_user_data(GTK_OBJECT(menuitem), no);
				gtk_signal_connect(GTK_OBJECT(menuitem),
					  "activate",
					  GTK_SIGNAL_FUNC(service_menu), 
					  p2->svc);
			}
			g_free(p2);
		}
	}
	s=users;
	while(s) {
		if (!option_port_scan || s->port == 0) {
			menuitem = gtk_menu_item_new_with_label(s->name);
			if (option_port_scan)
				gtk_menu_prepend(GTK_MENU(menu), menuitem);
			else
				gtk_menu_append(GTK_MENU(menu), menuitem);
			gtk_widget_show(menuitem);
			gtk_object_set_user_data(GTK_OBJECT(menuitem), no);
			gtk_signal_connect(GTK_OBJECT(menuitem),
				  "activate",
				  GTK_SIGNAL_FUNC(service_menu), 
				  s);
		}
		s=s->next;
	}
	/* Add portscan option */
	menuitem = gtk_menu_item_new();
	gtk_menu_prepend(GTK_MENU(menu), menuitem);
	gtk_widget_show(menuitem);
	menuitem = gtk_menu_item_new_with_label("Scan...");
	gtk_signal_connect(GTK_OBJECT(menuitem),
			   "activate",
			   GTK_SIGNAL_FUNC(scan_object), 
			   no);
	gtk_widget_show(menuitem);
	gtk_menu_prepend(GTK_MENU(menu), menuitem);
	/* Add MAP option */
	menuitem = gtk_menu_item_new_with_label("Map");
	gtk_signal_connect(GTK_OBJECT(menuitem),
			   "activate",
			   GTK_SIGNAL_FUNC(map_object), 
			   no);
	gtk_widget_show(menuitem);
	gtk_menu_prepend(GTK_MENU(menu), menuitem);
	/* Add Detect option */
	menuitem = gtk_menu_item_new_with_label("Detect");
	gtk_signal_connect(GTK_OBJECT(menuitem),
			   "activate",
			   GTK_SIGNAL_FUNC(detect_object), 
			   no);
	gtk_widget_show(menuitem);
	gtk_menu_prepend(GTK_MENU(menu), menuitem);

	gtk_menu_popup(GTK_MENU(menu), NULL, NULL, NULL, NULL, event->button, event->time);
}
