/*
 * Network Explorer
 *
 * Copyright (C) 1998, Mark Spencer
 * 
 * Distributed under the terms of the GNU GPL
 *
 */


#define SERVICES "services.conf"
#define DEFAULT_WIDTH 640
#define DEFAULT_HEIGHT 480
#define QUESO_CONF "cheops.conf"

#define DEFAULT_ICON "desktop.h"

#define FIXED_WIDTH 640 * 2
#define FIXED_HEIGHT 480 * 2

#define DEFAULT_ICON_WIDTH 120
#define DEFAULT_ICON_HEIGHT 80

#define STATE_NONE 0
#define STATE_PING 1
#define STATE_UP   2
#define STATE_ID   3
#define STATE_DOWN 4

#define Zzz 10

#include "gtklink.h"

#if (GTK_MINOR_VERSION > 1) || ((GTK_MICRO_VERSION > 1) &&  (GTK_MINOR_VERSION > 0))
	#define USE_ITEM
	#define GTK_MENU_FUNC(a) ((GtkItemFactoryCallback)(a))
#else
	#undef USE_ITEM
	typedef void (*_GTK_MENU_FUNC_T)(GtkWidget *, void *);
	#define GTK_MENU_FUNC(a) ((_GTK_MENU_FUNC_T)(a))
#endif

struct link;
struct plink;
struct pcache;
struct pageedit;
struct alias;

struct net_object
{
	GtkWidget *eventbox;
	GtkWidget *otherbox;
	GtkWidget *pixmap;
	GtkWidget *label;
	gint id;
	unsigned int ip_addr;
	char hostname[256];
	char os[256];
	char fn[256];
	int drag;
	int x, y;
	int xo, yo;
	int state;
	int mapped;
	struct link *links;
	struct alias *aliases;
	struct net_object *next;
	/* For rendering the map */
	int visited;
	int count;
};

struct net_win
{
	GtkWidget *window;
	GtkWidget *menu;
	GtkWidget *vbox;
	GtkWidget *notebook;
	GtkWidget *status;
	GtkTooltips *tips;
#ifdef USE_ITEM
	GtkItemFactory *menuf;
#else
	GtkMenuFactory *menuf;
#endif
	struct net_win *next;
};

struct network 
{
	unsigned int net_addr;
	unsigned int net_mask;
	struct network *next;
};

struct domain
{
	char domain[256];
	int recursive;
	struct domain *next;
};

struct ping_request {
	unsigned int addr;
	void *data;
	time_t timeout;
	struct ping_request *next;
};

struct net_page {
	GtkWidget *pane;
	GtkWidget *fixed;
	GtkWidget *space;
	GtkWidget *label;
	GtkWidget *notebook;
	GtkWidget *lasthand;
	GtkWidget *eventbox;
	GtkWidget *list;
	int lastid;
	struct net_object *objs;
	struct net_object *last;
	struct net_object *sel;
	char laststr[256];
	int lastx;
	int lasty;
	int automap;
	int icon_height;
	int icon_width;
	int small_icons;
	struct network *ncontents;
	struct domain *dcontents;
	struct pcache *pos;
	struct plink *pending;
	struct pageedit *pe;
};


#define FLAG_USERNAME 1


struct service {
	int port;
	char name[80];
	int (*connect)(struct service *svc, char *hostname, char *ip, char *username, int port);
	int flags;
	char format[256];
	struct service *next;
};

struct pixmap_cache {
	char filename[256];
	GdkPixmap *pixmap;
	GdkBitmap *mask;
	struct pixmap_cache *next;
};

struct port {
	/* A port to be scanned */
	unsigned short dport;
	unsigned short sport;
	int avail;
	struct port *next;
	struct service *svc;
};

struct link {
	/* A link between two objects */
	struct net_page *page;
	struct net_object *other;
	GtkWidget *linkw;
	struct link *next;
};

struct plink {
	/* A link we've discovered, but for which
	   no objects yet exist */
	unsigned int addr1;
	unsigned int addr2;
	struct plink *next;
};

struct pcache {
	/* Ones position on the screen */
	unsigned int addr;
	int x;
	int y;
	struct pcache *next;
};

struct pageedit {
	struct net_page *np;
	GtkWidget *window;
	GtkWidget *networks;
	GtkWidget *domains;
	GtkWidget *entry;
};

struct aliascache {
	struct aliascache *next;
	unsigned int addr;
	char hostname[256];
};

struct alias {
	struct alias *next;
	char hostname[256];
};

#define MAX_REQUEST_RETRIES 4
#define REQUEST_TIMEOUT     10

struct map_request {
	/* A request by the user to map an object */
	struct net_page *np;
	unsigned int dest;
	unsigned int last;
	char ttl;
	int retries;
	time_t sent;
	struct map_request *next;
};


/* Don't trace deeper than  this, to prevent infinite loops */
#define MAP_MAX	 	60

/* Don't retransmit more than this # every 100 ms */
#define MAP_TIMEOUT_MAX 5

/* Empty port for tracing routes */
#define EMPTY_PORT 33434

/* Max TCP port to scan */
#define MAX_TCP 8000

typedef void (*tcp_cb)(void *, int port); 

/* Arranging */
#define BY_OS 	1
#define BY_NAME 2
#define BY_ADDR 3
#define BY_DOMAIN 4
#define BY_MAP 5

#ifndef GPOINTER_TO_INT
#define GPOINTER_TO_INT(x) ((gint)x)
#endif

extern int discover_network_a(struct net_page *, char *, char *, int);
extern int net_init();
extern void add_object(struct net_page *, struct net_object *);
extern struct net_object *network_object(GdkWindow *, char *, char *);
extern void set_icon(struct net_object *no, char *);
extern void init_tcpip(void);
extern struct net_object *get_object(struct net_page *, unsigned int);
extern struct net_win main_window;
extern struct net_page *current_page;
extern int examine_host_queue(unsigned int, unsigned short, struct net_page * );
extern unsigned short inet_checksum (void *, int);
extern void add_unique(unsigned int, char *,char *, struct net_page *);
extern void set_status(char *);
extern void show_service_menu(struct net_object *no, GdkEventButton *event);
extern int try_ports[];
extern int init_halfscan(void);
extern int scan_ports(unsigned int, unsigned int, struct port *, int);
extern struct in_addr getlocalip (unsigned int dest);
extern void immediate_setcursor(int c);
extern int load_interfaces();
extern struct net_page *add_network(struct net_win *n, char *title);
extern int valid_np(struct net_page *np);
extern unsigned char *get_server(char *, int);
extern int gather_hosts(struct net_page *, char *, int, int);
extern void start_mapping(struct net_object *);
extern int handle_map(char *buf, int len, struct sockaddr_in *sin);
extern int seqno;
extern void sendicmp (int ttl, struct in_addr to, int rep);
extern void object_link(struct net_page *np, struct net_object *no, struct net_object *no2);
extern void check_connections(struct net_page *np, struct net_object *no);
extern int option_queso;
extern int option_trim;
extern int option_reverse_dns;
extern int option_port_scan;
extern int option_automap;
extern int option_remember_positions;
extern int option_add_routes;
extern int option_use_icmp;
extern int option_use_visible_area;
extern int option_update_release;
extern int option_remember_hosts;
extern int option_remember_connects;
extern int option_remember_aliases;
extern void show_options(void);
extern int load_options(void);
extern void show_about(void *, int);
extern void show_gpl(void);
extern int save_options(void);
extern char *gpl_text;
extern char *find_file(char *);
extern void show_edit(struct net_page *);
extern void do_network(GtkWidget *, int);
int append_network(struct pageedit *pe, struct network *);
int append_domain(struct pageedit *pe, struct domain *);
extern void reload_page(void);
extern void fix_icon(GdkWindow *);
extern void arrange(struct net_page *np, int how);
extern struct alias *build_aliases(unsigned int addr);
extern char *print_aliases(struct net_object *, char);
extern void fix_tooltip(struct net_object *);
extern void place_object(struct net_object *no, int xp, int yp);
extern void add_to_list(GtkWidget *, struct net_object *);
extern char *get_pm_name(char *fn, char *extn);
extern struct pixmap_cache *get_pixmap(char *filename);
extern void port_scanner(struct net_object *no);
extern int full_scan(tcp_cb callback, unsigned int src_addr, unsigned int dst_addr, int timeout, void *data);
extern char *get_version(unsigned int addr, unsigned short port);
extern char *get_name(unsigned short port);
extern char xterm[];
extern void do_save(GtkWidget *, char *);
extern int do_load(char *fn);
extern char defname[256];
extern struct pcache *get_cache(struct net_page *, unsigned int);
extern struct pcache *check_cache(struct net_page *, unsigned int);\
extern void fix_label(struct net_object *);
extern void map_connect(struct net_page *np, unsigned int addr1, unsigned int addr2, int);
extern void shrink_pixmaps(void);
extern void init_services(void);
extern void save_services(void);
extern int vnc_connect(struct service *svc, char *hostname, char *ip, char *username, int porti);
extern int generic_connect(struct service *svc, char *hostname, char *ip, char *username, int porti);
extern void register_service(char *name, int port, char *format, 
                      int (*connect_routine)(struct service *, char *, char *, char *, int),
		      int flags);
extern void unregister_service(struct service *);
extern struct service *users;
