/*
 * Network Explorer
 *
 * Copyright (C) 1998, Mark Spencer
 * 
 * Distributed under the terms of the GNU GPL
 *
 */

#include <gtk/gtk.h>
#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <arpa/inet.h>
#include <string.h>
#include <netdb.h>
#include "cheops.h"

GtkWidget *about=NULL;
GtkWidget *gpl=NULL;

static int timeout=0;

void destroy_about(GtkWidget *w, GtkWidget *l)
{
	if (timeout)
		gtk_timeout_remove(timeout);
	timeout = 0;
	if ((l != about) && (l != gpl))
		l = w;
	if (l)
		gtk_widget_destroy(l);
	if (l == about) {
		about = NULL;
	};
	if (l == gpl) {
		gpl = NULL;
	};
}

void show_gpl()
{
	
	GtkWidget *vbox;
	GtkWidget *hbox;
	GtkWidget *hbox2;
	GtkWidget *sb;
	GtkWidget *text;
	GtkWidget *close;
	GdkFont *font;
	
	font = gdk_font_load("fixed");
	
	if (timeout)
		gtk_timeout_remove(timeout);
	timeout = 0;

	if (gpl) {
		gtk_widget_show(gpl);
		gdk_window_raise(gpl->window);
		return;
	}
	gpl = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_widget_realize(gpl);
	fix_icon(gpl->window);
	text = gtk_text_new(NULL, NULL);
	hbox = gtk_hbox_new(FALSE, 0);
	hbox2 = gtk_hbox_new(FALSE, 0);
	sb = gtk_vscrollbar_new(GTK_TEXT(text)->vadj);
	
	close = gtk_button_new_with_label("Close");

#if 1
	gtk_widget_set_usize(text, 480, 200);
#endif

	
	vbox = gtk_vbox_new(FALSE, 5);
	gtk_box_pack_start(GTK_BOX(hbox), text, TRUE, TRUE, 5);
	gtk_box_pack_start(GTK_BOX(hbox), sb, FALSE, FALSE, 5);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, TRUE, 5);
	gtk_box_pack_end(GTK_BOX(hbox2), close, FALSE, FALSE, 5);
	gtk_box_pack_start(GTK_BOX(vbox), hbox2, FALSE, FALSE, 5);
	gtk_widget_show(vbox);
	gtk_widget_show(close);
	gtk_widget_show(text);
	gtk_widget_show(sb);
	gtk_widget_show(hbox2);
	gtk_widget_show(hbox);
	gtk_signal_connect(GTK_OBJECT(close), "clicked", GTK_SIGNAL_FUNC(destroy_about), gpl);
	gtk_signal_connect(GTK_OBJECT(gpl), "delete_event", GTK_SIGNAL_FUNC(destroy_about), gpl);
	
	gtk_container_add(GTK_CONTAINER(gpl), vbox);
	gtk_widget_grab_focus(close);
	
	gtk_window_set_title(GTK_WINDOW(gpl), "License: GNU General Public License");
	gtk_widget_realize(gpl);
	gtk_widget_realize(vbox);
	gtk_widget_realize(hbox);
	gtk_widget_realize(text);
	gtk_text_insert(GTK_TEXT(text), font, NULL, NULL, gpl_text, strlen(gpl_text));
	
	gtk_widget_show(gpl);
}

static int timeout_callback(void *data)
{
	if (about) {
		destroy_about(about, about);
	}
	return FALSE;
}

void show_about(void *ign, int time)
{
	GdkPixmap *gdk_pixmap=NULL;
	GdkBitmap *gdk_pixmap_mask=NULL;
	GtkWidget *pixmap;
	GtkWidget *close;
	GtkWidget *license;
	GtkWidget *fixed;
	GtkStyle *style;

	if (time)
		timeout = gtk_timeout_add(time, timeout_callback, NULL);
	if (about) {
		gtk_widget_show(about);
		gdk_window_raise(about->window);
		return;
	}
	if (timeout)
		about = gtk_window_new(GTK_WINDOW_POPUP);
	else
		about = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_widget_realize(about);
	fix_icon(about->window);
	
	style = gtk_widget_get_style(about);
	gdk_pixmap = gdk_pixmap_create_from_xpm (about->window, &gdk_pixmap_mask, 
				   &style->bg[GTK_STATE_NORMAL],
				   find_file("cheops.xpm"));
	
	pixmap = gtk_pixmap_new(gdk_pixmap, gdk_pixmap_mask);
	
	
	fixed = gtk_fixed_new();
	close = gtk_button_new_with_label("Close");
	license = gtk_button_new_with_label("License");
	
	gtk_fixed_put(GTK_FIXED(fixed), pixmap, 0, 0);
	gtk_fixed_put(GTK_FIXED(fixed), close, 23, 208);
	gtk_fixed_put(GTK_FIXED(fixed), license, 188, 208);
	
	
	gtk_widget_show(pixmap);
	gtk_widget_show(fixed);
	gtk_widget_show(close);
	gtk_widget_show(license);
	
	gtk_container_add(GTK_CONTAINER(about), fixed);
	gtk_window_set_title(GTK_WINDOW(about), "About Cheops");

	gtk_signal_connect(GTK_OBJECT(license), "clicked", GTK_SIGNAL_FUNC(show_gpl), NULL);
	gtk_signal_connect(GTK_OBJECT(close), "clicked", GTK_SIGNAL_FUNC(destroy_about), about);
	gtk_signal_connect(GTK_OBJECT(about), "delete_event", GTK_SIGNAL_FUNC(destroy_about), about);

	gtk_widget_grab_focus(close);
	
	gtk_window_position(GTK_WINDOW(about), GTK_WIN_POS_CENTER);
	gtk_window_set_policy(GTK_WINDOW(about), FALSE, FALSE, FALSE);
	gtk_widget_show(about);
}
