/*
 * Choeps Next Generation
 * 
 * Brent Priddy <toopriddy@mailcity.com>
 *
 * Copyright(C) 1999, Adtran, Inc.
 * 
 * Distributed under the terms of the GNU General Public License (GPL) Version
 *
 * Osscan shim for porting nmap into cheops-ng
 *
 */

#include <netdb.h>
#include <pthread.h>
#include "../io.h"
#include "../cheops-agent.h"
#include "../event.h"
#include "../logger.h"
#include "../cheops-agent.h"
#include "../agent-osscan.h"
#include "my-nmap.h"
#include "nmap.h"
#include "osscan.h"

//#define DEBUG_ON

#ifdef DEBUG_ON
	#define DEBUG(a)  a
#else
	#define DEBUG(a) 
#endif

/* global options */
struct ops o;			/* option structure */

static char ebuf_os[MAX_EVENT_SIZE];
static event_hdr *eh_os = (event_hdr *)ebuf_os;
static event *ee_os = (event *)(ebuf_os + sizeof(event_hdr));

extern pthread_mutex_t os_write_mutex;

void agent_osscan_send_event(agent *a, event_hdr *e);

extern char *scan_ports;
extern unsigned int scan_flags;

int send_osscan_reply (struct hoststruct *currenths,void *np, agent * a)
{
	int i, length, len;
	char *opt;
	os_scan_option_os *os_opt;
	os_scan_option_port *os_port;
	port *current = currenths->ports;
	port *tmp;
	struct servent *service;

	pthread_mutex_lock(&os_write_mutex);

	length = sizeof (event_hdr) + sizeof (os_scan_r);

	eh_os->hlen = htons (sizeof (event_hdr));
	eh_os->type = htons (REPLY_OS_SCAN);
	eh_os->flags = 0;
	ee_os->os_scan_r.num_options = htonl (1);
	ee_os->os_scan_r.ip = htonl(currenths->host.s_addr);
	ee_os->os_scan_r.np = np;
	
	opt = (void *) ee_os + sizeof (os_scan_r);
	i = 0;
	while (currenths->FP_matches[i])
	{
		os_opt = (void *) opt;
		os_opt->type = htonl (OS_SCAN_OPTION_OS);
		strcpy ((char *) &os_opt->string, (char *) currenths->FP_matches[i]->OS_name);

		len = sizeof (os_scan_option_os) + strlen (currenths->FP_matches[i]->OS_name);
		length += len;
		os_opt->length = htonl (len);

		/* advance to the next option */
		opt += len;
		i++;
	}
	ee->os_scan_r.num_options = htonl (i);
	
	DEBUG(printf("%s(): sending %d types\n", __FUNCTION__, i));

	i = 0;
	while (current != NULL)
	{
		len = sizeof (os_scan_option_port);
		os_port = (void *) opt;
		os_port->type = htonl (OS_SCAN_OPTION_PORT);
		os_port->length = htonl (len);
		os_port->protocol = current->proto;
		os_port->state = htonl (current->state);
		os_port->port_number = htons (current->portno);
		service = nmap_getservbyport(os_port->port_number, (current->proto == IPPROTO_TCP)?"tcp":"udp");
		if(service)
			strcpy(os_port->name, service->s_name);
		else
			os_port->name[0] = '\0';
		
		tmp = current;
		current = current->next;
		if (tmp->owner)
			free (tmp->owner);
		free (tmp);

		/* advance to the next option */
		length += len;
		opt += len;
		i++;
	}
	currenths->ports = NULL;
	
	DEBUG(printf("%s(): sending %d ports\n", __FUNCTION__, i));

	ee_os->os_scan_r.num_options += htonl (i);
	eh_os->len = htonl (length);

	agent_osscan_send_event(a, eh_os);

	return (1);
}

int send_osports_reply (struct hoststruct *currenths,void *np, agent * a)
{
	int i, length, len;
	char *opt;
	os_scan_option_os *os_opt;
	os_scan_option_port *os_port;
	port *current = currenths->ports;
	port *tmp;
	struct servent *service;

	pthread_mutex_lock(&os_write_mutex);

	length = sizeof (event_hdr) + sizeof (os_scan_r);

	eh_os->hlen = htons (sizeof (event_hdr));
	eh_os->type = htons (REPLY_OS_SCAN);
	eh_os->flags = 0;
	ee_os->os_scan_r.num_options = htonl (1);

	printf("IP : %d\n", htonl(currenths->host.s_addr));

	ee_os->os_scan_r.ip = htonl(currenths->host.s_addr);
	ee_os->os_scan_r.np = np;
	
	opt = (void *) ee_os + sizeof (os_scan_r);
	i = 0;
	os_opt = (void *) opt;
	os_opt->type = htonl (OS_SCAN_OPTION_OS);
	strcpy ((char *) &os_opt->string, "UNKNOWN");

	len = sizeof (os_scan_option_os) + strlen ("UNKNOWN");
	length += len;
	os_opt->length = htonl (len);

	/* advance to the next option */
	opt += len;
	i++;
	ee->os_scan_r.num_options = htonl (i);
	
	DEBUG(printf("%s(): sending %d types\n", __FUNCTION__, i));

	i = 0;
	while (current != NULL)
	{
		len = sizeof (os_scan_option_port);
		os_port = (void *) opt;
		os_port->type = htonl (OS_SCAN_OPTION_PORT);
		os_port->length = htonl (len);
		os_port->protocol = current->proto;
		os_port->state = htonl (current->state);
		os_port->port_number = htons (current->portno);
		service = nmap_getservbyport(os_port->port_number, (current->proto == IPPROTO_TCP)?"tcp":"udp");
		if(service)
			strcpy(os_port->name, service->s_name);
		else
			os_port->name[0] = '\0';
		
		tmp = current;
		current = current->next;
		if (tmp->owner)
			free (tmp->owner);
		free (tmp);

		/* advance to the next option */
		length += len;
		opt += len;
		i++;
	}
	currenths->ports = NULL;
	
	DEBUG(printf("%s(): sending %d ports\n", __FUNCTION__, i));

	ee_os->os_scan_r.num_options += htonl (i);
	eh_os->len = htonl (length);

	agent_osscan_send_event(a, eh_os);

	return (1);
}


int do_osscan (char *name, void *np, void *agent)
{
	int i;
	short randomize = 1, resolve_all = 0;
	int numhosts_scanned = 0;
	int numhosts_up = 0;
	int starttime;
	struct timeval tv;	/* Just for seeding random generator */
	unsigned short *ports = NULL;
	char myname[MAXHOSTNAMELEN + 1];
#if (defined(IN_ADDR_DEEPSTRUCT) || defined( SOLARIS))
/* Note that struct in_addr in solaris is 3 levels deep just to store an
 * unsigned int! */
	struct ftpinfo ftp =
	{FTPUSER, FTPPASS, "",
	 {
		 {
			 {0}}}, 21, 0};
#else
	struct ftpinfo ftp =
	{FTPUSER, FTPPASS, "",
	 {0}, 21, 0};
#endif
	struct hostent *target = NULL;
	struct hoststruct *currenths;
	char emptystring[1];
	int sourceaddrwarning = 0;	/* Have we warned them yet about unguessable
					   source addresses? */

/* Seed our random generator */
	gettimeofday (&tv, NULL);
	if (tv.tv_usec)
		srand (tv.tv_usec);
	else if (tv.tv_sec)
		srand (tv.tv_sec);
	else
		srand (time (NULL));

/* initialize our options */
	options_init ();

	emptystring[0] = '\0';	/* It wouldn't be an emptystring w/o this ;) */

// My options

	// the rule is: if they specify the ports then we use them
	if((scan_flags & OS_SCAN_OPTION_FASTSCAN) && 
	   (scan_flags & OS_SCAN_OPTION_USE_PORT_RANGE))
	{
		scan_flags &= ~OS_SCAN_OPTION_FASTSCAN;
	}


	o.udpscan = (scan_flags & OS_SCAN_OPTION_UDP_SCAN) ? 1 : 0;
	o.connectscan = (scan_flags & OS_SCAN_OPTION_TCP_CONNECT_SCAN) ? 1 : 0;
	o.synscan = (scan_flags & OS_SCAN_OPTION_TCP_SYN_SCAN) ? 1 : 0;
	o.finscan = (scan_flags & OS_SCAN_OPTION_STEALTH_FIN) ? 1 : 0;
	o.xmasscan = (scan_flags & OS_SCAN_OPTION_STEALTH_XMAS) ? 1 : 0;
	o.nullscan = (scan_flags & OS_SCAN_OPTION_STEALTH_NULL) ? 1 : 0;
	o.osscan = (scan_flags & OS_SCAN_OPTION_OSSCAN) ? 1 : 0;
	o.fastscan = (scan_flags & OS_SCAN_OPTION_FASTSCAN) ? 1 : 0;
	o.pingtype = (scan_flags & OS_SCAN_OPTION_DONT_PING) ? PINGTYPE_NONE : PINGTYPE_ICMP;

	DEBUG(
		printf("scan flags = %08X\n",scan_flags);
		printf("o.udpscan      %d\n",o.udpscan);
		printf("o.connectscan  %d\n",o.connectscan);
		printf("o.synscan      %d\n",o.synscan);
		printf("o.finscan      %d\n",o.finscan);
		printf("o.xmasscan     %d\n",o.xmasscan);
		printf("o.nullscan     %d\n",o.nullscan);
		printf("o.osscan       %d\n",o.osscan);
		printf("o.fastscan     %d\n",o.fastscan);
		printf("o.pingtype     %d\n",o.pingtype);
	);		

// ok, if they did not specify fastscan then all is ok to use their port range
	if(scan_flags & OS_SCAN_OPTION_USE_PORT_RANGE)
		ports = getpts(scan_ports);
		

	o.reference_FPs = parse_fingerprint_reference_file ();

	if (o.pingtype == PINGTYPE_UNKNOWN)
	{
		if (o.isr00t)
			o.pingtype = PINGTYPE_TCP | PINGTYPE_TCP_USE_ACK | PINGTYPE_ICMP;
		else
			o.pingtype = PINGTYPE_TCP;
	}


/* Now we check the option sanity */
/* Insure that at least one scantype is selected */
	if (!o.connectscan && !o.udpscan && !o.synscan && !o.finscan && !o.maimonscan && !o.nullscan && !o.xmasscan && !o.bouncescan && !o.pingscan)
	{
		o.connectscan++;
		if (o.verbose)
			error ("No scantype specified, assuming vanilla tcp connect() scan. Use -sP if you really don't want to portscan (and just want to see what hosts are up).");
	}

	if (o.fastscan)
	{
		ports = getfastports (o.synscan | o.connectscan | o.fragscan | o.finscan | o.maimonscan | o.bouncescan | o.nullscan | o.xmasscan, o.udpscan);
	}

	if (!ports)
	{
		ports = getdefaultports (o.synscan | o.connectscan | o.fragscan | o.finscan |
		      o.maimonscan | o.bouncescan | o.nullscan | o.xmasscan,
					 o.udpscan);
	}

/* Default dest port for tcp probe */
	if (!o.tcp_probe_port)
		o.tcp_probe_port = 80;


	if (o.pingscan && (o.connectscan || o.udpscan || o.synscan || o.finscan || o.maimonscan || o.nullscan || o.xmasscan || o.bouncescan))
	{
		fatal ("Ping scan is not valid with any other scan types (the other ones all include a ping scan");
	}

	if (o.max_sockets > MAX_SOCKETS_ALLOWED)
	{
		error ("Warning: You are limited to MAX_SOCKETS_ALLOWED (%d) parallel sockets.  If you really need more, change the #define and recompile.\n", MAX_SOCKETS_ALLOWED);
		o.max_sockets = MAX_SOCKETS_ALLOWED;
	}

/* Set up our array of decoys! */
	if (o.decoyturn == -1)
	{
		o.decoyturn = (o.numdecoys == 0) ? 0 : get_random_uint () % o.numdecoys;
		o.numdecoys++;
		for (i = o.numdecoys - 1; i > o.decoyturn; i--)
			o.decoys[i] = o.decoys[i - 1];
	}

/* We need to find what interface to route through if:
 * --None have been specified AND
 * --We are root and doing tcp ping OR
 * --We are doing a raw sock scan and NOT pinging anyone */
	if (o.source && !*o.device)
	{
		if (ipaddr2devname (o.device, o.source) != 0)
		{
			fatal ("Could not figure out what device to send the packet out on with the source address you gave me!  If you are trying to sp00f your scan, this is normal, just give the -e eth0 or -e ppp0 or whatever.  Otherwise you can still use -e, but I find it kindof fishy.");
		}
	}

	if (*o.device && !o.source)
	{
		o.source = safe_malloc (sizeof (struct in_addr));
		if (devname2ipaddr (o.device, o.source) == -1)
		{
			fatal ("I cannot figure out what source address to use for device %s, does it even exist?", o.device);
		}
	}


	fflush (stdout);

	if (o.max_sockets && (i = max_sd ()) && i < o.max_sockets)
	{
		fprintf (stderr, "WARNING:  Your specified max_parallel_sockets of %d, but your system says it might only give us %d.  Trying anyway\n", o.max_sockets, i);
	}

	if (!o.max_sockets)
	{
		o.max_sockets = max_sd ();
		if (!o.max_sockets)
			o.max_sockets = 60;
		else if (o.max_sockets > 5)
			o.max_sockets -= 4;	/* To make up for misc. uncounted sockets */
		o.max_sockets = MIN (o.max_sockets, 125);
	}

	if (randomize)
		shortfry (ports);

	starttime = time (NULL);

	if ((currenths = nexthost (name, 500, o.ptime)) && currenths->host.s_addr)
	{
		numhosts_scanned++;
		if (currenths->flags & HOST_UP)
			numhosts_up++;

		/*    printf("Nexthost() returned: %s\n", inet_ntoa(currenths->host)); */
		target = NULL;
//		if (((currenths->flags & HOST_UP) || resolve_all) && !o.noresolve)
//			target = gethostbyaddr ((char *) &currenths->host, 4, AF_INET);
		if (0 && target)
		{
			currenths->name = strdup (target->h_name);
		}
		else
		{
			currenths->name = emptystring;
		}

		if (o.source)
			memcpy (&currenths->source_ip, o.source, sizeof (struct in_addr));
		if (!o.pingscan)
		{
			if (o.pingtype != PINGTYPE_NONE && (currenths->flags & HOST_UP) && (o.verbose || o.debugging))
				fprintf (o.nmap_stdout, "Host %s (%s) appears to be up ... good.\n", currenths->name, inet_ntoa (currenths->host));
			else if (o.verbose && o.pingtype != PINGTYPE_NONE && !(currenths->flags & HOST_UP))
			{
				if (resolve_all)
					nmap_log ("Host %s (%s) appears to be down, skipping it.\n", currenths->name, inet_ntoa (currenths->host));
				else
					fprintf (o.nmap_stdout, "Host %s (%s) appears to be down, skipping it.\n", currenths->name, inet_ntoa (currenths->host));
			}

		}
		else
		{
			if (currenths->flags & HOST_UP)
			{
				nmap_log ("Host %s (%s) appears to be up.\n", currenths->name, inet_ntoa (currenths->host));
				nmap_machine_log ("Host: %s (%s)\tStatus: Up\n", inet_ntoa (currenths->host), currenths->name);
			}
			else if (o.verbose || o.debugging || resolve_all)
			{
				if (resolve_all)
					nmap_log ("Host %s (%s) appears to be down.\n", currenths->name, inet_ntoa (currenths->host));
				else
					fprintf (o.nmap_stdout, "Host %s (%s) appears to be down.\n", currenths->name, inet_ntoa (currenths->host));
			}
		}

		if (currenths->wierd_responses)
		{
			nmap_log ("Host  %s (%s) seems to be a subnet broadcast address (returned %d extra pings).  Skipping host.\n", currenths->name, inet_ntoa (currenths->host), currenths->wierd_responses);
			nmap_machine_log ("Host: %s (%s)\tStatus: Smurf (%d responses)\n", inet_ntoa (currenths->host), currenths->name, currenths->wierd_responses);
		}

		/* The !currenths->wierd_responses was commented out after I found
		   a smurf address which DID allow port scanninng and you could even
		   telnetthere.  wierd :0 */
		if (currenths->flags & HOST_UP /* && !currenths->wierd_responses */  &&
		    !o.pingscan)
		{

			if (currenths->flags & HOST_UP && !currenths->source_ip.s_addr && (o.synscan || o.finscan || o.maimonscan || o.udpscan || o.nullscan || o.xmasscan))
			{
				if (gethostname (myname, MAXHOSTNAMELEN) ||
				    !(target = gethostbyname (myname)))
					fatal ("Cannot get hostname!  Try using -S <my_IP_address> or -e <interface to scan through>\n");
				memcpy (&currenths->source_ip, target->h_addr_list[0], sizeof (struct in_addr));
				if (!sourceaddrwarning)
				{
					fprintf (stderr, "WARNING:  We could not determine for sure which interface to use, so we are guessing %s .  If this is wrong, use -S <my_IP_address>.\n", inet_ntoa (currenths->source_ip));
					sourceaddrwarning = 1;
				}
			}

			/* Figure out what link-layer device (interface) to use (ie eth0, ppp0, etc) */
			if (!*currenths->device && currenths->flags & HOST_UP && (o.nullscan || o.xmasscan || o.udpscan || o.finscan || o.maimonscan || o.synscan || o.osscan) && (ipaddr2devname (currenths->device, &currenths->source_ip) != 0))
				fatal ("Could not figure out what device to send the packet out on!  You might possibly want to try -S (but this is probably a bigger problem).  If you are trying to sp00f the source of a SYN/FIN scan with -S <fakeip>, then you must use -e eth0 (or other devicename) to tell us what interface to use.\n");
			/* Set up the decoy */
			o.decoys[o.decoyturn] = currenths->source_ip;

			/* Time for some actual scanning! */


			if (o.synscan)
				pos_scan (currenths, ports, SYN_SCAN);
			if (o.connectscan)
				pos_scan (currenths, ports, CONNECT_SCAN);

			if (o.finscan)
				super_scan (currenths, ports, FIN_SCAN);
			if (o.xmasscan)
				super_scan (currenths, ports, XMAS_SCAN);
			if (o.nullscan)
				super_scan (currenths, ports, NULL_SCAN);
			if (o.maimonscan)
				super_scan (currenths, ports, MAIMON_SCAN);
			if (o.udpscan)
				super_scan (currenths, ports, UDP_SCAN);

			if (o.bouncescan)
			{
				if (ftp.sd <= 0)
					ftp_anon_connect (&ftp);
				if (ftp.sd > 0)
					bounce_scan (currenths, ports, &ftp);
			}

			if (o.osscan)
			{
				os_scan (currenths);
			}

			if (!currenths->ports && !o.pingscan)
			{
				nmap_log ("No ports open for host %s (%s)\n", currenths->name,
					  inet_ntoa (currenths->host));
				nmap_machine_log ("Host: %s (%s)\tStatus: Up",
						  inet_ntoa (currenths->host), currenths->name);
			}
			if (currenths->ports)
			{
//				nmap_log ("Interesting ports on %s (%s):\n", currenths->name,
//					  inet_ntoa (currenths->host));
//				nmap_machine_log ("Host: %s (%s)", inet_ntoa (currenths->host),
//						  currenths->name);
				invertfirewalled (&currenths->ports, ports);
			//	printandfreeports(currenths->ports);
			}
			if (o.osscan)
			{
				if (currenths->seq.responses > 3)
				{
//					nmap_log ("%s", seqreport (&(currenths->seq)));
//					nmap_machine_log ("\tSeq Index: %d", currenths->seq.index);
				}
				if (currenths->FP_matches[0])
				{
//					nmap_machine_log ("\tOS: %s", currenths->FP_matches[0]->OS_name);
					i = 1;
					while (currenths->FP_matches[i])
					{
//						nmap_machine_log ("|%s", currenths->FP_matches[i]->OS_name);
						i++;
					}

					send_osscan_reply (currenths, np, agent);


					if (!currenths->FP_matches[1])
//						nmap_log ("Remote operating system guess: %s",
//							  currenths->FP_matches[0]->OS_name);
;					else
					{
//						nmap_log ("Remote OS guesses: %s",
//							  currenths->FP_matches[0]->OS_name);
						i = 1;
						while (currenths->FP_matches[i])
						{
//							nmap_log (", %s", currenths->FP_matches[i]->OS_name);
							i++;
						}
					}
//					nmap_log ("\n");
					if (currenths->goodFP >= 0 && (o.debugging || o.verbose > 1))
					{
//						nmap_log ("OS Fingerprint:\n%s\n", fp2ascii (currenths->FPs[currenths->goodFP]));
					}
//					nmap_log ("\n");
				}
				else
				{
					send_osports_reply (currenths, np, agent);
					if (currenths->goodFP == ENOMATCHESATALL)
					{
						nmap_log ("No OS matches for host (see http://www.insecure.org/cgi-bin/nmap-submit.cgi).\nTCP/IP fingerprint:\n%s\n\n", mergeFPs (currenths->FPs, currenths->numFPs));
					}
					else if (currenths->goodFP == ETOOMANYMATCHES)
					{
						nmap_log ("Too many fingerprints match this host for me to give an accurate OS guess\n");
						if (o.debugging || o.verbose)
						{
							nmap_log ("TCP/IP fingerprint:\n%s\n\n", mergeFPs (currenths->FPs, currenths->numFPs));
						}
					}
				}
				for (i = 0; i < currenths->numFPs; i++)
					freeFingerPrint (currenths->FPs[i]);
			}



			if (currenths->ports)
			{
				send_osports_reply (currenths, np, agent);
//				printandfreeports (currenths->ports);
			}




			if (o.machinelogfd)
				fflush (o.machinelogfd);
			if (o.debugging)
				fprintf (o.nmap_stdout, "Final times for host: srtt: %d rttvar: %d  to: %d\n", currenths->to.srtt, currenths->to.rttvar, currenths->to.timeout);
			nmap_machine_log ("\n");
		}
		fflush (stdout);
		if (o.machinelogfd)
			fflush (o.machinelogfd);
		if (o.logfd)
			fflush (o.logfd);
	}

//	i = time (NULL) - starttime;
//	fprintf (o.nmap_stdout, "Nmap run completed -- %d %s (%d %s up) scanned in %d %s\n", numhosts_scanned, (numhosts_scanned == 1) ? "IP address" : "IP addresses", numhosts_up, (numhosts_up == 1) ? "host" : "hosts", i, (i == 1) ? "second" : "seconds");
	return 0;
}


