/*
 * Cheops Next Generation GUI
 * 
 * Brent Priddy <toopriddy@mailcity.com>
 *
 * Copyright(C) 1999, Adtran, Inc.
 * 
 * Distributed under the terms of the GNU General Public License (GPL) Version
 *
 * Header file for the service callback stuff (spawning a program that has 
 * something to do with the port/protocol that is running on a host)
 *
 */
typedef struct _service_list_t {
	char                   *name;
	int                     port;
	int                     protocol;
	char                   *command;
	struct _service_list_t *next;
} service_list_t;

extern service_list_t *service_list;

extern int service_callback(int ip, int port, int protocol); 
extern service_list_t *service_list_add(char *name, int port, int protocol, char *string);
extern service_list_t *service_list_change(service_list_t *service, char *name, int port, int protocol, char *string);
extern void service_list_default(void);

extern void service_list_remove(int port, int protocol);
extern void service_list_remove_ptr(service_list_t *t);
extern char *service_list_get(int port, int protocol);

extern service_list_t *services_make_dialog(service_list_t *service, char *name, int port, int protocol, char *str, GtkWidget *parent);
extern os_pixmap_list_t *os_pixmaps_make_dialog(os_pixmap_list_t *os_pixmap, char *pix, char *str, GtkWidget *parent);




