/*
 * Cheops Next Generation
 * 
 * Brent Priddy <toopriddy@mailcity.com>
 *
 * Copyright(C) 1999, Adtran, Inc.
 * 
 * Distributed under the terms of the GNU General Public License (GPL) Version
 *
 * Osscan schtuf for cheops-ng
 *
 */

#ifndef _CHEOPS_OSSCAN_H
#define _CHEOPS_OSSCAN_H

typedef struct _os_scan_option {
	u32	type;
	u32	length;
} os_scan_option;

typedef struct _os_scan_option_os {
#define OS_SCAN_OPTION_OS 1
	u32	type;
	u32	length;
	char	*string;
} os_scan_option_os;

typedef struct _os_scan_option_port {
#define OS_SCAN_OPTION_PORT 2
	u32	type;
	u32	length;
	u8	protocol;
	u32	state;
	u16	port_number;
	char name[40];
} os_scan_option_port;

void add_service(u16 port, u8 protocol, char *name);

void remove_service(u16 port, u8 protocol);

void remove_all_services(void);

char *get_service(u16 port, u8 protocol);




#endif /* _CHEOPS_AGENT_OSSCAN_H */


