#
# perl/saintwriter.pl
#
# rewrite saintwriter.cf after the user changes it.
#
# suck in the changes, then just cycle through each line of the .cf file.
# if there is a match, put the new value in there.
#

sub write_saintwriter_file {
local($new_values) = @_;
local(%new_values, $variable, $old_variable, $old_value);

#
# split the strings into something easier to handle
for ( split(/\n/, $new_values) ) {
	next if !$_;

	($variable, $value) = split(/=/, $_);

	# need to stick a dollar sign in front of var
	$variable = "\$" . "$variable";
	# put quotes around value
	# and convert plusses back to spaces
	$value = "\"$value\"";
	$value =~ s/\+/ /g;

	$new_values{$variable} = $value;
	}

#
# re-create the basic config file
#
    $configfile = "config/saintwriter/saintwriter.cf";
    die "Can't read $configfile.new\n" unless open(CFN, ">$configfile.new");

    print CFN "# Basic SAINTwriter configuration\n";
    print CFN "\$report = $new_values{'$report'};\n";
    print CFN "\$format = $new_values{'$format'};\n";
    print CFN "1;\n";
    close(CFN);

    system("mv $configfile $configfile.old");
    system("mv $configfile.new $configfile");

#
# open the report-specific config file
#
$configfile = "config/saintwriter/$new_values{'$report'}.cf";
$configfile =~ s/\"//g;
die "Can't read $configfile\n" unless open(CF, "$configfile");
die "Can't write $configfile.new\n" unless open(CFN, ">$configfile.new");

while (<CF>) {
	if (/^# Begin vulnerabilities/) {
	    print CFN;
	    for $variable (keys %new_values) {
		if ($variable =~ /^\$red_/ ||
		    $variable =~ /^\$yellow_/ ||
		    $variable =~ /^\$brown_/ ||
		    $variable =~ /^\$green_/) {
			print CFN "$variable = $new_values{$variable};\n";
		}
	    }	
	    $_ = <CF>;
	    while (! /^# End vulnerabilities/) {
		$_ = <CF>;
	    }
	}

	if (!/^\$/) {
		print CFN $_;
		next;
		}
	
	chop;
	($old_variable, $old_value) = split(/\s*=\s*/, $_);

	# kill spaces and semicolons
	$old_variable =~ s/\s//g;
	$old_value =~ s/;//g;
	if ($new_values{'$longform'} eq "\"on\"") {
	    $old_value = "\"off\"" if ($old_value eq "\"on\"" || $old_value eq "\"reverse\"");
	}

	# suck in the lines, compare them to each of the vars gotten from user
	for $variable (keys %new_values) {
		if ($variable eq $old_variable) {
			$old_value = $new_values{$variable};
			}
		}

	print CFN "$old_variable = $old_value;\n";
	}

close(CF);
close(CFN);

# move the evidence to where it belongs... old to .old, new to .cf:
system("mv $configfile $configfile.old");
system("mv $configfile.new $configfile");

}

1;
