#TRUSTED a330903223c7f3109e6657ecb92bf16dd9845cc15af64ca0257a37a1a6dd01e8d7ddd4ac901da4c7cf55afc9e862b934d719fa2c3048481b1ef84dfb0dc112371880c9404e9f7a0904c9a69d7da43b4bf91e0caab505581619c75baaf94ecd82f9c4bf291ac4fb3679a013e18b00591cdb40ded6c22b2e9c33b94327f84932a6448c4f1c0e59a2c640b8d77775ee7c6c3fdf742b525c7692157c08adb95bb18ad32f1421227dfd50a3d8cc4d26feb6ce8f1c86a39084e91054c644b7c615361bcb1c338815bb7fd1f89598624b27b0dcebefa617530e1f984c91532b118e378350acc3e20c3792d95837f1adc94b381a5c09f45c684c35639720db0d9599f6b5eb4c50017951879a838895dbed10fe7475079d84bdebb09978d1f074b74470eaf8173b9d9ea84e7113a0ab95ee1aae876c56a02a1b508d5e6d9c4ee59f71ac0759736fc97f7e40a4441811cc98ed559779278eb2bc2e772b7cf16e05ca306fbe4c36225c983fdf9aa302933da5b78bf2d3fda874d508e7682e2f39df65f71ba33ce779b638cf836b47443a1b95859445d0a464bd1e808324d13ff7d7e3fd4612dcd5cc0e4bbf2949c7f2f2068121b6d9d476de5efc3f5351bd1279bd758bdf9f9223aab1cd1e029216983188da3f03f565fbf4926952cf97e6990be1bbaa833849e8760224c40138dc10c927dde60c7c45b8f6ede6dd50f350d22e0d14803cb4
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra")) exit(0);


if(description)
{
 script_id(15881);
 script_version ("1.2");
 name["english"] = "Hydra: POP3";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find POP3 accounts & passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force POP3 authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/logins_file", "Secret/hydra/passwords_file");
 script_require_ports("Services/pop3", 110);
 script_dependencies("hydra_options.nasl", "find_service.nes", "doublecheck_std_services.nasl");
 exit(0);
}

#
throrough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< throrough) exit(0);
logins = get_kb_item("Secret/hydra/logins_file");
passwd = get_kb_item("Secret/hydra/passwords_file");
if (logins == NULL || passwd == NULL) exit(0);

port = get_kb_item("Services/pop3");
if (! port) port = 110;
if (! get_port_state(port)) exit(0);

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
login_pass = get_kb_item("/tmp/hydra/login_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");
tr = get_kb_item("Transports/TCP/"+port);

i = 0;
argv[i++] = "hydra";
argv[i++] = "-s"; argv[i++] = port;
argv[i++] = "-L"; argv[i++] = logins;
argv[i++] = "-P"; argv[i++] = passwd;
s = "";
if (empty) s = "n";
if (login_pass) s+= "s";
if (s)
{
  argv[i++] = "-e"; argv[i++] = s;
}
if (exit_asap) argv[i++] = "-f";
if (tr >= ENCAPS_SSLv2) argv[i++] = "-S";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-t";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "pop3";

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*login: *(.*) password: *(.*)$');
  if (! isnull(v))
  {
    l = chomp(v[1]);
    p = chomp(v[2]);
    report = strcat(report, 'username: ', l, '\tpassword: ', p, '\n');
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to break the following POP3 accounts:\n' + report);
