#TRUSTED 2d9d7459d85592df322bcc1aac2580e35d648e77a1b9224dc53f4c8437ad1ca48a81dbd7d4b0ff8f348b0418cba4c01d28bd726d4692e60a62256d6d8814b89644a4949d45291087c0f57d9703dced3a11c50e185e90243dc797c3d5b567e4b915e243c3ec82eba146c6fd10a6f985faada4c9161ef4aecb9d517b87be4786d026bbe98174e7ca8440ea4dafec4694efe2312a4c729bc722b9a44bc181dce1a0c61890b07ba1ead4f5c6d4652fe0d7da502c7ff089b4326d07f71b032e923600decabcfe7337c7bddb428b126b8dec431465b40ef81f383920799ee48ab4a33f03d7fc9011384ee61a700d94719492db0a60e45d221086b28027993d2bf8bbc7fa05238fc801e396d9b8de22e99cd99e7da6032d577d7ecc4bda3b5deba68dec42d7c20074ffb865ff1c171ac5f8f56e825d4d2165bf22791ec05504059d66e4739e480c05f6f6dc46ffc9ab1ac4393f53ab387e1b9fc3ca46a7fa359c97ce3c9dc7fbb823111a6e579f0fca278f7890b562866006de5da68c7c0a29b2b5c3a7d0aeb3e2bd27c466aebeac4c16cf2ac10fa23f3a6b7c387a7e76fcc903be6ade7f3e9800b4d80abf02e681bf30386567453fb06cbfd513590783a07dd43509ebf196b7243aa60b25cdbbafbcc56876c8bb72ffd7b8389c61449cd9d55bb97ee4eb3a76d878d6337649241b3eee45ffdad7b65c48075b6de0451c94a6c4fca3a0
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra")) exit(0);


if(description)
{
 script_id(15873);
 script_version ("1.3");
 script_xref(name: "OWASP", value: "OWASP-AUTHN-004");
 script_xref(name: "OWASP", value: "OWASP-AUTHN-006");
 script_xref(name: "OWASP", value: "OWASP-AUTHN-010");
 name["english"] = "Hydra: HTTP";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find HTTP passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force HTTP authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 
 script_add_preference(name: "Web page (required) :", value: "/", type: "entry");

 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/logins_file", "Secret/hydra/passwords_file");
 script_require_ports("Services/www", 80);
 script_dependencies("hydra_options.nasl", "find_service.nes", "doublecheck_std_services.nasl");
 exit(0);
}

#

throrough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< throrough) exit(0);
logins = get_kb_item("Secret/hydra/logins_file");
passwd = get_kb_item("Secret/hydra/passwords_file");
if (logins == NULL || passwd == NULL) exit(0);

port = get_kb_item("Services/www");
if (! port) port = 80;
if (! get_port_state(port)) exit(0);

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
login_pass = get_kb_item("/tmp/hydra/login_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");
tr = get_kb_item("Transports/TCP/"+port);

i = 0;
argv[i++] = "hydra";
argv[i++] = "-s"; argv[i++] = port;
argv[i++] = "-L"; argv[i++] = logins;
argv[i++] = "-P"; argv[i++] = passwd;
s = "";
if (empty) s = "n";
if (login_pass) s+= "s";
if (s)
{
  argv[i++] = "-e"; argv[i++] = s;
}
if (exit_asap) argv[i++] = "-f";
if (tr >= ENCAPS_SSLv2) argv[i++] = "-S";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-t";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "http";

opt = script_get_preference("Web page (required) :");
if (! opt) exit(0);
argv[i++] = opt;

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*login: *(.*) password: *(.*)$');
  if (! isnull(v))
  {
    l = chomp(v[1]);
    p = chomp(v[2]);
    report = strcat(report, 'username: ', l, '\tpassword: ', p, '\n');
    set_kb_item(name: 'Hydra/http/'+port, value: l + '\t' + p);
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to break the following HTTP accounts:\n' + report);
