# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200503-35.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2005 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(17665);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200503-35");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200503-35
(Smarty: Template vulnerability)


    A vulnerability has been discovered within the regex_replace
    modifier of the Smarty templates when allowing access to untrusted
    users.
  
Impact

    This issue may allow a remote attacker to bypass the "template
    security" feature of Smarty, and execute arbitrary PHP code.
  
Workaround

    Do not grant template access to untrusted users.
  
References:
    http://smarty.php.net/misc/NEWS


Solution: 
    All Smarty users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=dev-php/smarty-2.6.8"
  

Risk factor : High
';
 script_description(english: desc);
 script_copyright(english: "(C) 2005 Michel Arboi");
 script_name(english: "[GLSA-200503-35] Smarty: Template vulnerability");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Smarty: Template vulnerability');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "dev-php/smarty", unaffected: make_list("ge 2.6.8"), vulnerable: make_list("lt 2.6.8")
)) { security_hole(0); exit(0); }
