# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200501-11.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2005 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(16402);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200501-11");
 script_cve_id("CAN-2005-0012");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200501-11
(Dillo: Format string vulnerability)


    Gentoo Linux developer Tavis Ormandy found a format string bug in
    Dillo\'s handling of messages in a_Interface_msg().
  
Impact

    An attacker could craft a malicious web page which, when accessed
    using Dillo, would trigger the format string vulnerability and
    potentially execute arbitrary code with the rights of the user running
    Dillo.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CAN-2005-0012


Solution: 
    All Dillo users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=www-client/dillo-0.8.3-r4"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2005 Michel Arboi");
 script_name(english: "[GLSA-200501-11] Dillo: Format string vulnerability");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Dillo: Format string vulnerability');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "www-client/dillo", unaffected: make_list("ge 0.8.3-r4"), vulnerable: make_list("lt 0.8.3-r4")
)) { security_warning(0); exit(0); }
