/* Nessus
 * Copyright (C) 1998 Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * In addition, as a special exception, Renaud Deraison
 * gives permission to link the code of this program with any
 * version of the OpenSSL library which is distributed under a
 * license identical to that listed in the included COPYING.OpenSSL
 * file, and distribute linked combinations including the two.
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * this file, you may extend this exception to your version of the
 * file, but you are not obligated to do so.  If you do not wish to
 * do so, delete this exception statement from your version.
 */
 
#include <includes.h>

#ifdef USE_GTK
#include <gtk/gtk.h>
#include "read_target_file.h"
#include "nessus_i18n.h"

struct arglist *
prefs_dialog_target()
{
  GtkWidget * frame;
  GtkWidget * vbox;
  GtkWidget * label;
  GtkWidget * check_dns;
  GtkWidget * entry;
  GtkWidget * hbox;
  GtkWidget * button;
  struct arglist *  ctrls = emalloc(sizeof(struct arglist));

  /* The overall frame */
  frame = gtk_frame_new(_("Target selection"));
  gtk_container_border_width(GTK_CONTAINER(frame), 10);
  gtk_widget_show(frame);
  arg_add_value(ctrls, "FRAME", ARG_PTR, -1, frame);

  /* the overall vbox that will contain all widgets */
  vbox = gtk_vbox_new(FALSE, 4);
  gtk_container_add(GTK_CONTAINER(frame), vbox);
  gtk_widget_show(vbox);

  /* The hbox that contains the target entry and file selection button */
  hbox = gtk_hbox_new(FALSE, 5);
  gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
  gtk_widget_show(hbox);

  /* The label for target entry */
  label = gtk_label_new(_("Target(s):"));
  gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
  gtk_widget_show(label);

  /* The target entry */
  entry = gtk_entry_new();
  gtk_box_pack_start(GTK_BOX(hbox), entry, FALSE, FALSE, 0);
  gtk_widget_show(entry);
  arg_add_value(ctrls, "TARGET", ARG_PTR, -1, entry);

  /* The button for reading target from a file */
  button = gtk_button_new_with_label(_("Read file..."));
  gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, FALSE, 0);
  gtk_signal_connect(GTK_OBJECT(button), "clicked",
                     (GtkSignalFunc)target_file_select, NULL);
  gtk_widget_show(button);
  arg_add_value(ctrls, "READ_FROM_FILE", ARG_PTR, -1, button);

  /* Checkbox for Zone transfer */
  check_dns = gtk_check_button_new_with_label(_("Perform a DNS zone transfer"));
  gtk_box_pack_start(GTK_BOX(vbox), check_dns, FALSE, FALSE, 0);
  gtk_widget_show(check_dns);
  arg_add_value(ctrls, "DNS_EXPAND", ARG_PTR, -1, check_dns);

  return(ctrls);
}
#endif
