/* $Id: prefs_comment.c,v 1.6 2004/11/29 16:15:02 thomas Exp $
 *
 * Copyright (C) 2004 by Intevation GmbH
 * Author(s):
 * Jan-Oliver Wagner <jan@intevation.de>
 * Thomas Arendsen Hein <thomas@intevation.de>
 *
 * This program is free software under the GNU GPL (>=v2)
 * Read the file COPYING coming with the software for details.
 *
 * In addition, as a special exception, Intevation GmbH gives
 * permission to link the code of this program with the OpenSSL
 * library (or with modified versions of OpenSSL that use the same
 * license as OpenSSL), and distribute linked combinations including
 * the two. You must obey the GNU General Public License in all
 * respects for all of the code used other than OpenSSL. If you
 * modify this file, you may extend this exception to your version
 * of the file, but you are not obligated to do so. If you do not
 * wish to do so, delete this exception statement from your version.
 */

#include <includes.h>

#include <gtk/gtk.h>

#include "preferences.h"
#include "nessus_i18n.h"

/*
 * Fill comment textview with preferences
 */
void
fill_comment(context, ctrls)
  struct context *context;
  struct arglist *ctrls;
{
  GtkTextBuffer *buffer = gtk_text_view_get_buffer(
      GTK_TEXT_VIEW(arg_get_value(ctrls, "COMMENT")));
  const gchar *text;

  text = prefs_get_string(context, "comment");

  if(text)
  {
    /* XXX remove unescaping as soon as prefs_get_string handles this */
    gchar *escaped = g_strcompress(text);

    gtk_text_buffer_set_text(buffer, escaped, -1);
    g_free(escaped);
  }
  else
    gtk_text_buffer_set_text(buffer, "", -1);
}

/*
 * Save comment from textview to preferences
 */
void
store_comment(context, ctrls)
  struct context *context;
  struct arglist *ctrls;
{
  GtkTextBuffer *buffer = gtk_text_view_get_buffer(
      GTK_TEXT_VIEW(arg_get_value(ctrls, "COMMENT")));
  GtkTextIter start, end;
  gchar *text, *escaped;

  gtk_text_buffer_get_bounds(buffer, &start, &end);
  text = gtk_text_buffer_get_text(buffer, &start, &end, FALSE);
  /* XXX remove escaping as soon as prefs_set_string handles this */
  escaped = g_strescape(text, NULL);
  g_free(text);
  prefs_set_string(context, "comment", escaped);
  g_free(escaped);
}

/*
 * Build a box element with a comment text editing field.
 */
struct arglist *
prefs_dialog_comment(void)
{
  struct arglist *ctrls = emalloc(sizeof(struct arglist));
  GtkWidget *box, *scrolledwindow, *textview;

  box = gtk_vbox_new(FALSE, FALSE);
  arg_add_value(ctrls, "VBOX", ARG_PTR, -1, box);

  scrolledwindow = gtk_scrolled_window_new(NULL, NULL);
  gtk_box_pack_start(GTK_BOX(box), scrolledwindow, TRUE, TRUE, 5);
  gtk_widget_show(scrolledwindow);

  textview = gtk_text_view_new();
  gtk_container_add(GTK_CONTAINER(scrolledwindow), textview);
  arg_add_value(ctrls, "COMMENT", ARG_PTR, -1, textview);
  gtk_widget_show(textview);

  gtk_widget_show(box);

  return ctrls;
}
