/* $Id: prefs_about.c,v 1.19 2004/12/14 07:43:53 thomas Exp $
 *
 * Copyright (C) 2004 by Intevation GmbH
 * Author(s):
 * Thomas Arendsen Hein <thomas@intevation.de>
 *
 * This program is free software under the GNU GPL (>=v2)
 * Read the file COPYING coming with the software for details.
 *
 * In addition, as a special exception, Intevation GmbH gives
 * permission to link the code of this program with the OpenSSL
 * library (or with modified versions of OpenSSL that use the same
 * license as OpenSSL), and distribute linked combinations including
 * the two. You must obey the GNU General Public License in all
 * respects for all of the code used other than OpenSSL. If you
 * modify this file, you may extend this exception to your version
 * of the file, but you are not obligated to do so. If you do not
 * wish to do so, delete this exception statement from your version.
 */

#include <includes.h>
#include "nessus_i18n.h"

#ifdef USE_GTK
#include <gtk/gtk.h>
#include <corevers.h>
#include "xstuff.h"
#include "globals.h"

#include "xpm/nessus.xpm"
#include "xpm/logo_tenable.xpm"
#include "xpm/logo_intevation.xpm"
#include "xpm/logo_bsi.xpm"
#ifdef HAVE_GNU_GETTEXT
# include "xpm/logo_bsi_de.xpm"
#endif


static void
about_add_text(box, text)
  GtkWidget *box;
  const char *text;
{
  GtkWidget *label;

  label = gtk_label_new(text);
  gtk_widget_show(label);
  gtk_box_pack_start(GTK_BOX(box), label, FALSE, FALSE, 0);
  gtk_misc_set_alignment(GTK_MISC(label), 0, 0.5);
  gtk_label_set_selectable(GTK_LABEL(label), TRUE);
}

static void
about_add_logo(box, xpm, alt_text, url)
  GtkWidget *box;
  char **xpm;
  const char *alt_text;
  const char *url;
{
  GtkWidget *vbox;
  GtkWidget *pixmap;

  vbox = gtk_vbox_new(FALSE, 4);
  gtk_widget_show(vbox);
  gtk_box_pack_start(GTK_BOX(box), vbox, FALSE, FALSE, 0);

  if(F_show_pixmaps)
  {
    pixmap = make_pixmap(vbox, NULL, xpm);
    gtk_widget_show(pixmap);
    gtk_box_pack_start(GTK_BOX(vbox), pixmap, FALSE, FALSE, 0);
    gtk_misc_set_alignment(GTK_MISC(pixmap), 0, 0.5);
  }
  else
    about_add_text(vbox, alt_text);

  about_add_text(vbox, url);
}


void
prefs_dialog_about(menuitem, ctrls)
  GtkMenuItem *menuitem;
  gpointer ctrls;
{
  GtkWindow *window = GTK_WINDOW(arg_get_value(ctrls, "WINDOW"));
  GtkWidget *dialog;
  GtkWidget *hbox;
  GtkWidget *vbox;
  GtkWidget *vseparator;
  gchar *text;
  char **bsilogo = logo_bsi_xpm;
#ifdef HAVE_GNU_GETTEXT
  char *lc_messages;
#endif

  dialog = gtk_dialog_new_with_buttons(_("About the Nessus Client"),
      window, GTK_DIALOG_DESTROY_WITH_PARENT,
      GTK_STOCK_CLOSE, GTK_RESPONSE_CLOSE, NULL);

  gtk_window_set_transient_for(GTK_WINDOW(dialog), window);
  g_signal_connect(dialog, "response", G_CALLBACK(gtk_widget_destroy), NULL);

  gtk_window_set_resizable(GTK_WINDOW(dialog), FALSE);

  hbox = gtk_hbox_new(FALSE, 10);
  gtk_widget_show(hbox);
  gtk_container_set_border_width(GTK_CONTAINER(hbox), 10);
  gtk_box_pack_start_defaults(GTK_BOX(GTK_DIALOG(dialog)->vbox), hbox);

  /*
   * left column
   */

  vbox = gtk_vbox_new(FALSE, 12);
  gtk_widget_show(vbox);
  gtk_box_pack_start_defaults(GTK_BOX(hbox), vbox);

  about_add_logo(vbox, nessus_xpm,
      _("Nessus"), _("http://www.nessus.org/"));

  text = g_strdup_printf(_("Nessus Client %s"
	"\nCopyright 1998-2004 Renaud Deraison"), NESSUS_FULL_VERSION);
  about_add_text(vbox, text);
  g_free(text);

  about_add_text(vbox, _("Authors:"
	"\n Renaud Deraison"
	"\n Thomas Arendsen Hein"
	"\n Jan-Oliver Wagner"
	"\n Michel Arboi (SSL Support)"
	"\n Bruce Verderaime (Pie/Charts)"
	));

  about_add_text(vbox, _("Mailing list: http://list.nessus.org/"));

  /*
   * right column
   */

  vseparator = gtk_vseparator_new();
  gtk_widget_show(vseparator);
  gtk_box_pack_start_defaults(GTK_BOX(hbox), vseparator);

  vbox = gtk_vbox_new(FALSE, 12);
  gtk_widget_show(vbox);
  gtk_box_pack_start_defaults(GTK_BOX(hbox), vbox);

  about_add_logo(vbox, logo_tenable_xpm,
      _("Tenable Network Security"), _("http://www.tenablesecurity.com/"));

  about_add_logo(vbox, logo_intevation_xpm,
      _("Intevation GmbH"), _("http://www.intevation.net/"));

#ifdef HAVE_GNU_GETTEXT
  lc_messages = setlocale(LC_MESSAGES, NULL);
  if(lc_messages && !strncmp(lc_messages, "de", 2))
    bsilogo = logo_bsi_de_xpm;
#endif
  about_add_logo(vbox, bsilogo,
      _("Federal Office for Information Security"),
      _("http://www.bsi.de/english/"));

  gtk_widget_show(dialog);
}
#endif /* USE_GTK */
