#
# (C) Tenable Network Security
#


if(description)
{
 script_id(15951);
 script_bugtraq_id(11900);
 script_version("$Revision: 1.1 $");
 name["english"] = "UBB.threads Cross Site Scripting Vulnerabilities";
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running UBB.threads, a bulletin board system written in PHP.

There are various cross-site scripting issues in the remote version of this
software. An attacker may exploit them to use the remote website to conduct
attacks against third parties.

Solution : Upgrade to the latest version of this software
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "XSS UBB.threads";
 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "CGI abuses";
 script_family(english:family["english"]);
 script_dependencie("http_version.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

# Check starts here

include("http_func.inc");
include("http_keepalive.inc");


function check(loc)
{
 res = http_keepalive_send_recv(port:port, data:http_get(item:loc + "/calendar.php?Cat=<script>foo</script>", port:port));
 if ( res == NULL ) exit(0);
 if ( "<script>foo</script>" >< res )
	{	
	 security_warning(port);
	 exit(0);
	}
}

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if ( ! can_host_php(port:port) ) exit(0);


foreach dir (cgi_dirs()) 
 {
  check(loc:dir);
 }
