#
#  This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
#  This script is released under the GNU GPLv2
#

if(description)
{
  script_id(15936);
  script_version("$Revision: 1.1 $");
  script_name(english:"PunBB detection");

  desc["english"] = "
The remote host seems to be running PunBB, an open source 
fast and lightweight PHP powered discussion board. 
	
Risk factor : None";

  script_description(english:desc["english"]);

  script_summary(english:"Checks for presence of PunBB");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"This script is Copyright (C) 2004 David Maciejak");

  script_family(english:"CGI abuses");
  script_require_ports("Services/www");
  exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);
if(!get_port_state(port))exit(0);
if(http_is_dead(port:port))exit(0);

if(!can_host_php(port:port))exit(0);

function check(url)
{
  req = http_get(item:string(url, "index.php"), port:port);
  r = http_keepalive_send_recv(port:port, data:req);
  if ( r == NULL ) exit(0);
  http_close_socket(soc);

  version=eregmatch(pattern: '.*Powered by <a target=\"_blank\" href=\"http://www\\.punbb\\.org/\">PunBB</a><br>.+Version: (.+)<br>.*',string: r);
  if (version)
  {
   report = "
The remote host is to running PunBB " + version[0] + ",
a fast and lightweight PHP powered discussion board. 
	
Risk factor : None";

    if ( ! url ) url = "/";

    set_kb_item(name:"www/" + port + "/punBB",value:version[0] + " under " + url);
    security_note(port:port, data:report);
    exit(0);
  }
}

foreach dir (cgi_dirs())
{
 check(url:dir);
}
