#TRUSTED 5465f65c903422431ac0b7fe2503e97d6230a544f06811f8e5d75fb027338a9388d9bb8ecd811c8f39c6bfcf8bdafa5971a2683b84c309707d874eb25c7fbb8bb868cd1b3f6eedfe0948d4545b89de2a6589c8f537327aa4328446263e58c7066438e9e79947312c19b1e528c3f78ff54283a964b67f1efda49d1b6020aaba33af3ac65436f0de0d600d11fa298884b5f6817fae2179fc8a9215f171779eb32c0ff5aa0370787ec6fa1855562177142b3a48013fc44c3ebfdac40caf523b07be760dc420b0b6f0bf3fa20dca648221e9743ee93e6706d06fe7260e4e4412278153111efa5da137ab3c099997e139e65ee167e4abca925a1e58402a822136fc3cad2d32dd013253407d7616012d36be8c0aa38ef9608e8605c410c977c6e97a047ee4f09a67e158838ad46d185669fcfb5cf98f422c39dd2ad72b6288cc93f635324effec284240871af47dd2cc545ddefb003923d7da1a8d4bd581ebaa0a9813ee15019282c8768fb3c4f9a39fd967425720f00cbf52127a45b1adedb2d5e3b86f9391ba9bdabc75d1010d1172bb46a8ba67cb2cd55918b12fa6a267789e8c3b1c1303b557d6805998408d1c9104c52dd23705875f76ec43c96d9d7169c60693b8aaa72e96a83d8284bc2e82b9d94ad68ff875705547d7996cf47a6b0c0125d73b7ce9d3f6c1354eef6ddc33ccf852065e916d36adf3c9a445abce5b6efd201c
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra") ) exit(0);


if(description)
{
 script_id(15890);
 script_version ("1.1");
 name["english"] = "Hydra: VNC";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find VNC passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force VNC authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/passwords_file");
 script_require_ports("Services/vnc", 5900);
# We are not able to detect VNC... yet
 script_dependencies("hydra_options.nasl", "find_service.nes", "doublecheck_std_services.nasl");
 exit(0);
}

#

throrough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< throrough) exit(0);
passwd = get_kb_item("Secret/hydra/passwords_file");
if (passwd == NULL) exit(0);

port = get_kb_item("Services/vnc");
if (! port) port = 5900;
if (! get_port_state(port)) exit(0);

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");
tr = get_kb_item("Transports/TCP/"+port);

i = 0;
argv[i++] = "hydra";
argv[i++] = "-p"; argv[i++] = port;
argv[i++] = "-P"; argv[i++] = passwd;
if (empty)
{
  argv[i++] = "-e"; argv[i++] = "n";
}
if (exit_asap) argv[i++] = "-f";
if (tr >= ENCAPS_SSLv2) argv[i++] = "-S";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-w";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "vnc";

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*(login: *.*)? password: *(.*)$');
  if (! isnull(v))
  {
    p = chomp(v[2]);
    report = strcat(report, p, '\n');
    set_kb_item(name: 'Hydra/vnc/'+port, value: l + '\t' + p);
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to find the following VNC passwords:\n' + report);
