# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200404-18.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2004 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(14483);
 script_bugtraq_id(10150);
 script_version("$Revision: 1.3 $");
 script_xref(name: "GLSA", value: "200404-18");
 script_cve_id("CAN-2004-0156");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200404-18
(Multiple Vulnerabilities in ssmtp)


    There are two format string vulnerabilities inside the log_event() and
    die() functions of ssmtp. Strings from outside ssmtp are passed to various
    printf()-like functions from within log_event() and die() as format
    strings. An attacker could cause a specially-crafted string to be passed to
    these functions, and potentially cause ssmtp to execute arbitrary code.
  
Impact

    If ssmtp connects to a malicious mail relay server, this vulnerability can
    be used to execute code with the rights of the mail sender, including root.
  
Workaround

    There is no known workaround at this time. All users are advised to upgrade
    to the latest available version of ssmtp.
  
References:
    http://secunia.com/advisories/11378/
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CAN-2004-0156
    http://lists.debian.org/debian-security-announce/debian-security-announce-2004/msg00084.html


Solution: 
    All users are advised to upgrade to the latest available version of ssmtp.
    # emerge sync
    # emerge -pv ">=net-mail/ssmtp-2.60.7"
    # emerge ">=net-mail/ssmtp-2.60.7"
  

Risk Factor : High
';
 script_description(english: desc);
 script_copyright(english: "(C) 2004 Michel Arboi");
 script_name(english: "[GLSA-200404-18] Multiple Vulnerabilities in ssmtp");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Multiple Vulnerabilities in ssmtp');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "net-mail/ssmtp", unaffected: make_list("ge 2.60.7"), vulnerable: make_list("le 2.60.4-r2")
)) { security_hole(0); exit(0); }
