#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12542);
 script_version ("$Revision: 1.2 $");
 script_cve_id("CAN-2003-1022", "CAN-2004-0011");
 name["english"] = "FreeBSD Ports : fspd < 2.8.1.19";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an installed version of the fspd package which is older
than 2.8.1.19.

fspd is a FSP (File Service Protocol) server. The remote version of this
software is vulnerable to two security issues which may allow a user to
escape the FSP root directory and to overflow a fixed-length buffer to 
execute arbitrary code on the remote host, with the privileges of the fspd
server.

Solution : http://www.vuxml.org/freebsd/20be2982-4aae-11d8-96f2-0020ed76ef5a.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the fspd package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^fspd", string:pkgs);
if ( ! package ) exit(0);
if ( pkg_cmp(pkg:package, reference:"fspd-2.8.1.19") < 0 ) 
	security_hole(0);


