/* $Id: report.c,v 1.70 2004/11/29 16:47:46 thomas Exp $
 *
 * Copyright (C) 1998, 1999, 2000 Renaud Deraison
 * Copyright (C) 2004 by Intevation GmbH
 * Author(s):
 * Thomas Arendsen Hein <thomas@intevation.de>
 *
 * This program is free software under the GNU GPL (>=v2)
 * Read the file COPYING coming with the software for details.
 *
 * In addition, as a special exception, Renaud Deraison
 * gives permission to link the code of this program with any
 * version of the OpenSSL library which is distributed under a
 * license identical to that listed in the included COPYING.OpenSSL
 * file, and distribute linked combinations including the two.
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * this file, you may extend this exception to your version of the
 * file, but you are not obligated to do so.  If you do not wish to
 * do so, delete this exception statement from your version.
 */

#include <includes.h>
#include "nessus_i18n.h"
#include "context.h"
#include "error_dialog.h"

#ifdef USE_GTK
#include <gtk/gtk.h>
#include "prefs_dialog/prefs_scope_tree.h"
#include "prefs_dialog/prefs_context.h"
#endif

#include "report.h"
#include "backend.h"
#include "nbe_output.h"


/* returns filename of report (must be freed) or NULL */
char *
report_get_filename(context)
  struct context *context;
{
  char *report = NULL;

  if(context->type == CONTEXT_REPORT && context->dir)
  {
    report = emalloc(strlen(context->dir) + strlen("/report.nbe") + 1);
    sprintf(report, "%s/report.nbe", context->dir);
  }
  return report;
}


/* reports back the highest number */
int is_there_any_hole(arglist)
 struct arglist * arglist;
{
 int ret = 0;
 /* Pluto 25.6.00: with three level of return, real sort */
 while(arglist && arglist->next && (ret!=HOLE_PRESENT))
 {
  int tmp = 0;
  int tmp2 = 0;
  if(!arglist->name)
   {
    arglist = arglist->next;
    continue;
   }
  if(!strcmp(arglist->name, "REPORT"))tmp2 = HOLE_PRESENT;
  else if(!strcmp(arglist->name, "INFO"))tmp2 = WARNING_PRESENT;
  else if(!strcmp(arglist->name, "NOTE"))tmp2 = NOTE_PRESENT;
  /*
   * Check in the sublist
   */
  if(arglist->type == ARG_ARGLIST)tmp = is_there_any_hole(arglist->value);
  if(tmp >= tmp2)tmp2 = tmp;
  if(tmp2 >= ret)ret = tmp2;
  arglist = arglist->next;
 }
 return(ret);
}

#ifdef USE_GTK

void
report_save(context, backend, name)
  struct context *context;
  int backend;
  const char *name;
{
  struct context *report_context;
  char *report_filename;
  char *report_name;
  int report_len = strlen("Report YYYYMMDD-HHMMSS") + 1;
  time_t t;
  int error;

  context = context_by_type(context, CONTEXT_SCOPE);
  if(!context)
  {
    show_error(_("report_save() called with illegal type"));
    return;
  }

  if(name)
    report_context = scopetree_new(CONTEXT_REPORT, name, "");
  else
  {
    report_name = emalloc(report_len);
    t = time(NULL);
    strftime(report_name, report_len, "Report %Y%m%d-%H%M%S", localtime(&t));
    report_context = scopetree_new(CONTEXT_REPORT, report_name, NULL);
    efree(&report_name);
  }

  if(!report_context)
  {
    show_error(_("report_save() coudn't create context"));
    return;
  }
  report_filename = report_get_filename(report_context);
  if(!report_filename)
  {
    show_error(_("report_save() coudn't find a report filename"));
    return;
  }

  error = backend_to_nbe(backend, report_filename);
  efree(&report_filename);
  if(error)
  {
    show_error(_("report_save() coudn't save the report"));
    return;
  }
  prefs_context_update(report_context);
}


/*
 * Opens the report
 */
void
open_report(GtkWidget * dontcare, GtkWidget *nsr)
{
  const char *filename =
    gtk_file_selection_get_filename(GTK_FILE_SELECTION(nsr));
  int be = backend_import_report((char *)filename);

  if(be >= 0)
  {
    char *report_name = g_path_get_basename(filename);

    report_save(Context, be, report_name);
    g_free(report_name);
  }
}

/*
 * Menu selection to open the report
 */
void open_report_selectfile()
{
 GtkWidget * nsr;
 nsr = gtk_file_selection_new (_("Load file"));
 /*
  * CWD
  */
 gtk_file_selection_set_filename (GTK_FILE_SELECTION(nsr), "");
 gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (nsr)->ok_button),
                               "clicked", (GtkSignalFunc) open_report,(void *) nsr );

 gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION(nsr)->ok_button),
   					  "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy),
   					  (gpointer) nsr);

 gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION(nsr)->cancel_button),
   					  "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy),
   					  (gpointer) nsr);

 gtk_widget_show(nsr);
}
#endif
