/* $Id: prefs_options.c,v 1.4 2004/11/18 13:50:26 thomas Exp $
 *
 * Copyright (C) 2004 by Intevation GmbH
 * Author(s):
 * Jan-Oliver Wagner <jan@intevation.de> (2004)
 *
 * This program is free software under the GNU GPL (>=v2)
 * Read the file COPYING coming with the software for details.
 *
 * In addition, as a special exception, Intevation GmbH gives
 * permission to link the code of this program with the OpenSSL
 * library (or with modified versions of OpenSSL that use the same
 * license as OpenSSL), and distribute linked combinations including
 * the two. You must obey the GNU General Public License in all
 * respects for all of the code used other than OpenSSL. If you
 * modify this file, you may extend this exception to your version
 * of the file, but you are not obligated to do so. If you do not
 * wish to do so, delete this exception statement from your version.
 */

#include <includes.h>

#include <gtk/gtk.h>

#include "prefs_dialog_scan_opt.h"
#include "prefs_plugins.h"
#include "prefs_dialog_plugins_prefs.h"
#include "prefs_target.h"
#include "prefs_dialog_user.h"
#ifdef ENABLE_SAVE_KB
# include "prefs_kb.h"
#endif

#include "nessus_i18n.h"

/*
 * Build a vbox element with a notebook for the configuration
 * options subgroups.
 */
struct arglist *
prefs_dialog_options(context, ctrls)
  struct context * context;
  struct arglist * ctrls;
{
  struct arglist * prefs_scan;
  struct arglist * prefs_plugins;
  struct arglist * prefs_plugins_prefs;
  struct arglist * prefs_target;
  struct arglist * prefs_user;
#ifdef ENABLE_SAVE_KB
  struct arglist * prefs_kb;
#endif
  GtkWidget * notebook;
  GtkWidget * box;
  GtkWidget * label, * subframe;
  GtkTooltips * tooltips;

  tooltips = gtk_tooltips_new();

  /* Set up a box */
  box = gtk_vbox_new(FALSE, FALSE);
  arg_add_value(ctrls, "VBOX", ARG_PTR, -1, box);
  gtk_widget_show(box);

  /* Set up a notebook in the box */
  notebook = gtk_notebook_new();
  gtk_notebook_set_tab_pos(GTK_NOTEBOOK(notebook), GTK_POS_LEFT);
  gtk_box_pack_start(GTK_BOX(box), notebook, TRUE, TRUE, 0);
  gtk_widget_show(notebook);
  arg_add_value(ctrls, "NOTEBOOK", ARG_PTR, -1, notebook);

  /*
   * Set up the pages of the notebook
   */

  prefs_scan = prefs_dialog_scan_opt(context);
  prefs_plugins = prefs_dialog_plugins(context);
  prefs_plugins_prefs = prefs_dialog_plugins_prefs();
  prefs_target = prefs_dialog_target();
  prefs_user = prefs_dialog_user();
#ifdef ENABLE_SAVE_KB
  prefs_kb = prefs_dialog_kb(); 
#endif 
  arg_add_value(ctrls, "SCAN_OPTIONS", ARG_ARGLIST, -1, prefs_scan);
  arg_add_value(ctrls, "PLUGINS", ARG_ARGLIST, -1, prefs_plugins);
  arg_add_value(ctrls, "PLUGINS_PREFS", ARG_ARGLIST, -1, prefs_plugins_prefs);
  arg_add_value(ctrls, "TARGET", ARG_ARGLIST, -1, prefs_target);
  arg_add_value(prefs_target, "MAIN", ARG_ARGLIST, -1, ctrls);
  arg_add_value(ctrls, "USER", ARG_ARGLIST, -1, prefs_user);
#ifdef ENABLE_SAVE_KB
  arg_add_value(ctrls, "SAVE_KB", ARG_ARGLIST, -1, prefs_kb);
#endif 

  /* The Scan options page */
  label = gtk_label_new(_("General"));
  subframe = arg_get_value(prefs_scan, "FRAME");
  gtk_widget_show(subframe);
  gtk_notebook_append_page(GTK_NOTEBOOK(notebook), subframe, label);

  /* The Plugin selection page */
  label = gtk_label_new(_("Plugins"));
  subframe = arg_get_value(prefs_plugins, "FRAME");
  gtk_widget_show(subframe);
  gtk_notebook_append_page(GTK_NOTEBOOK(notebook), subframe, label);

  /* The Plugin preferences page */
  label = gtk_label_new(_("Plugin Prefs."));
  subframe = arg_get_value(prefs_plugins_prefs, "FRAME");
  gtk_widget_show(subframe);
  gtk_notebook_append_page(GTK_NOTEBOOK(notebook), subframe, label);

  /* The target selection page */
  label = gtk_label_new(_("Target selection"));
  subframe = arg_get_value(prefs_target, "FRAME");
  gtk_widget_show(subframe);
  gtk_notebook_append_page(GTK_NOTEBOOK(notebook), subframe, label);

  /* The User-defined Access Rules page */
  label = gtk_label_new(_("Access Rules"));
  subframe = arg_get_value(prefs_user, "FRAME");
  gtk_widget_show(subframe);
  gtk_notebook_append_page(GTK_NOTEBOOK(notebook), subframe, label);

  /* The Knowledge Base page */
#ifdef ENABLE_SAVE_KB
  label = gtk_label_new(_("KB"));
  subframe = arg_get_value(prefs_kb, "FRAME");
  gtk_widget_show(subframe);
  gtk_notebook_append_page(GTK_NOTEBOOK(notebook), subframe, label);
#endif

  gtk_tooltips_enable(tooltips);

  return ctrls;
}
