/* Nessuslib -- the Nessus Library
 * Copyright (C) 1998 Renaud Deraison
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */   

#ifndef _NESSUSC_PREFS_HELP_H
#define _NESSUSC_PREFS_HELP_H

#include "../nessus_i18n.h"

#define HLP_AUTH_SERVER \
_("Enter the server name, where the Nessus Server resides on. \
This may be a domain name or an IP address.")

#define HLP_AUTH_PORT \
_("Enter the port number where you will be serviced by \
the Nessus Server. With older server systems, this is \
the port 3001, but the official port is 1241.")

#define HLP_AUTH_PORT_DEFAULT \
_("Set to default Nessus port 1241.")

#ifdef USE_ZLIB_COMPRESSION
# define HLP_CIPHER_CHOICE \
_("Enter the channel encryption <cipher>/<hash>:<compression>. \
A good choice for <cipher> is BLOWFISH, or TWOFISH an a good choice \
for <hash> is RIPEMD160. If you do not want any compression, use \
<cipher>/<hash>, only. If your bandwidth is a precious, use \
<cipher>/<hash>:9. For lowest compression (optimized \
for speed on your local computer) use <cipher>/<hash>:0.")
#else
# define HLP_CIPHER_CHOICE \
_("Enter the secure channel encrytion type as \
<cipher>/<hash>:<compression>. A good choice for <cipher> is \
blowfish, or twofish an \
a good choice for <hash> is ripemd160.")
#endif

#define HLP_LOGIN_USER \
_("Enter the user name where you are registerd with on the \
Nessus Server. If you log in for the first time, you will be \
asked for a password. Maybe you need to ask your Nessus Server \
administrator to create a login for you.")

#define HLP_MISC_MAX_HOSTS \
_("Maximal of number of hosts that the Nessus Server will test at \
the same time. Be aware that the Nessus Server will spawn max_hosts \
x max_checks processes!")

#define HLP_MISC_MAX_CHECKS \
_("Maximal number of security checks that will be launched at \
the same time against each host. Be aware that the Nessus Server will spawn \
max_hosts x max_checks processes!")

#define HLP_TEST_FILE \
_("Name of the remote file that several plugins will attempt \
to read.")

#define HLP_SCAN_OPT_PING \
_("If this option is checked, then Nessus Server will send \
some TCP packets to the target host to determine if the target host \
is alive. This method does not use ICMP as ICMP is unreliable as less \
and less hosts are answering to ICMP echo requests.")

#define HLP_SCAN_OPT_REVERSE_LOOKUP \
_("If this option is set, Nessus Server will do a reverse \
lookup on the IP addresses before it tests them. This may \
slow down the whole test.")

#define HLP_SCAN_OPT_FIREWALL \
_("Are the target hosts protected by a firewall ? If so \
and if we are outside the firewall, it is a good idea to \
turn this option ON, so that \
Nessus Server will perform some additional tests to check \
that the remote firewall is well \
configured (this option is still experimental).")

#define HLP_SCAN_OPT_OPTIMIZE \
_("Security tests may ask the Nessus Server to be \
launched if and only if some information gathered by other \
test exist in the knowledge base, or if and only if a given \
port is open. This option speeds up the test, but may \
make Nessus Server miss some vulnerability. If you are paranoid, \
disable this option")

#define HLP_SCAN_OPT_SAFE_CHECKS \
_("Some security checks may harm the target server, by \
disabling the remote service temporarily or until \
a reboot. If you enable this option, Nessus Server will \
rely on banners instead of actually performing \
a security check. You will obtain a less reliable \
report, but you will less likely disrupt the network users \
by doing a test. From a security point of view, we \
recommend you disable this option. From a sysadmin \
point of view, we recommand you enable it.")

#define HLP_SCAN_OPT_USE_MAC_ADDR \
_("If you enable this option, the hosts on the local network \
will be designated by their ethernet MAC address instead of \
their IP address. This is especially useful if you are using \
Nessus in a DHCP network. If unsure, disable this option.")

#define HLP_SCAN_OPT_PORT_RANGE \
_("Ports that will be scanned by Nessus Server. You can enter \
single ports, such as \"1-8000\"; or more complex sets, such \
as \"21,23,25,1024-2048,6000\". \
Put \"-1\" for no portscan, or put \"default\" to scan the default ports \
in the Nessus services file.")

#define HLP_UNSCANNED_CLOSED \
_("To save scanning time, you may ask Nessus Server to declare \
TCP ports it did not scan as closed. This will result in an incomplete audit \
but it will reduce scanning time and prevent Nessus Server from sending \
packets to ports you did not specify. \
If this option is disabled, then Nessus Server will consider ports whose \
state it does not know as open.")

#define HLP_HOST_EXPANSION_DNS \
_("Nessus Server will perform an AXFR request \
(that is, a zone transfer) to the target name server and will \
attempt to obtain the list of the hosts of the target domain. \
Then, it will test each host.")

#define HLP_HOST_EXPANSION_NFS \
_("Nessus Server will determine which hosts \
can mount the filesystems exported by the target server, and will test them. \
Beware : this test is recursive.")

#define HLP_HOST_EXPANSION_IP \
_("Nessus Server will test the whole subnet \
of the target host. If you select this option, you should allow Nessus Server \
to ping the hosts before scanning them in the 'Scan options' section.")

#define HLP_TARGET_PRIMARY_TARGET \
_("The first host(s) that will be attacked by Nessus Server. \
The options below allow you to extend the test to a larger set of \
computer. You may define several primary targets by separating \
them with a comma (,). ie : \"host1,host2\".")

#define HLP_TARGET_READ_FROM_FILE \
_("A textfile can be specified that contains the list of targets. \
This textfile may contain comma-separated lists of host and also \
may contain many of such lines.")

#define HLP_CGI_PATH \
_("It is possible to check for the presence of CGIs in multiple paths \
like /cgi-bin, /cgis, /home-cgis, and so on. In that case, put all your \
paths here separated by colons. For instance: \
'/cgi-bin:/cgi-aws:/~deraison/cgi'.")

#define HLP_WARNING \
_("The warning sign means that this plugin may harm the \
target host by disabling the attacked service or by crashing the host. \
You should be careful when you enable it since it may force you to reboot \
your servers or restart some services manually.")

#ifdef ENABLE_SAVE_KB

# define HLP_ENABLE_KB_SAVING \
_("If you turn on this option, all the information \
collected about the target hosts will be saved on the side of \
Nessus Server for further re-use. See \
http://www.nessus.org/doc/kb_saving.html for details.")

# define HLP_KB_TEST_ALL \
_("If you select this option, all the hosts selected \
in the 'Target' section of the Nessus Client will be tested.")

# define HLP_KB_TEST_TESTED \
_("If you select this option, only the hosts to \
which a recent knowledge base is attached will be tested.")

# define HLP_KB_TEST_UNTESTED \
_("If you select this option, only the hosts which \
have no (or an outdated) knowledge base attached will be tested. \
Use this option to populate your knowledge bases.")

# define HLP_RESTORE_KB \
_("If you select this option, the knowledge bases \
of the target hosts will be restored in memory if they are recent enough. \
You can use this option with the following ones to prevent Nessus Server \
to scan a host which was scanned in the past, or to prevent the security \
checks that were performed in the past to be performed again.")

# define HLP_KB_NO_SCANNER \
_("If you select this option, the port scanners \
that were launched in the past against the targetted hosts will not \
be launched again and the data of the knowledge base will be used \
as the result of the portscan.")

# define HLP_KB_NO_INFO \
_("If you select this option, all the plugins \
that performs information gathering and which have already been \
launched against the target hosts will not be launched again.")

# define HLP_KB_NO_ATTACK \
_("If you select this option, all the plugins \
that performs attacks and which have already been launched against the \
target hosts will not be launched again.")

# define HLP_KB_NO_DENIAL \
_("If you select this option, all the plugins \
that may harm the target hosts and which have already been launched \
will not be launched again.")

# define HLP_KB_MAX_AGE \
_("This value defines the maximum age (in seconds) \
of a knowledge base.")

# define HLP_DIFF_SCAN \
_("If this option is set, the client will only report \
what has changed between the new scan and the last one.")

#endif

#define HLP_ENABLE_DEPS_AT_RUNTIME \
_("If you enable this option, then Nessus Server \
will enable the plugins that are depended on by the set of plugins you \
selected.")

#endif
