/* $Id: context.h,v 1.8 2004/12/09 15:01:26 thomas Exp $
 *
 * Copyright (C) 2004 by Intevation GmbH
 * Author(s):
 * Thomas Arendsen Hein <thomas@intevation.de>
 *
 * This program is free software under the GNU GPL (>=v2)
 * Read the file COPYING coming with the software for details.
 *
 * In addition, as a special exception, Intevation GmbH gives
 * permission to link the code of this program with the OpenSSL
 * library (or with modified versions of OpenSSL that use the same
 * license as OpenSSL), and distribute linked combinations including
 * the two. You must obey the GNU General Public License in all
 * respects for all of the code used other than OpenSSL. If you
 * modify this file, you may extend this exception to your version
 * of the file, but you are not obligated to do so. If you do not
 * wish to do so, delete this exception statement from your version.
 */

#ifndef CONTEXT_H
#  define CONTEXT_H

#ifdef USE_GTK
#include <gtk/gtk.h>
#endif

typedef enum
{
  CONTEXT_GLOBAL = 0,
  CONTEXT_TASK,
  CONTEXT_SCOPE,
  CONTEXT_REPORT,
  CONTEXT_ENUM
} context_type;

struct context {
  context_type type;
  struct arglist *prefs;
  struct arglist *plugins;
  struct arglist *scanners;
  struct arglist *dependencies;
  char *dir;
  int socket;
  const char *passwd;
  struct context *parent;
  struct context *children;
  struct context *next;
#ifdef ENABLE_SAVE_TESTS
  harglst * sessions;
  int sessions_saved;
  int detached_sessions_saved;
#endif
#ifdef USE_GTK
  GtkTreeRowReference *treerowref;
  GtkWidget *move_menuitem;
  GtkWidget *plugin_prefs_swindow;
  GtkWidget *plugin_prefs_vbox;
#endif
};

extern struct context *Global;
extern struct context *Context;

void context_init(struct context**, struct context*);
struct context *context_by_type(struct context*, context_type);
#ifdef USE_GTK
void context_collect(struct context*);
void context_rename(struct context*, const char*);
int context_move(struct context*, struct context*);
struct context *context_new(struct context*, const char*, const char*);
void context_delete(struct context*);
void context_save_recurse(struct context*);

int check_exists(const char *);
int check_is_file(const char *);
int check_is_dir(const char *);
#endif /* USE_GTK */

#endif /* ifndef CONTEXT_H */

