/*
 *	passwdcheck.h
 *
 *      Copyright 1989 Clyde W. Hoover (Moose & Squirrel Software, NotInc.)
 *
 */

#define	EXPORT	/**/
#define	IMPORT	extern

#define	PWCK_FAIL	-1
#define	PWCK_OK		0
#define	PWCK_NULL	1
#define	PWCK_OBVIOUS	2
#define	PWCK_FINGER	3
#define	PWCK_INDICT	4
#define	PWCK_ILLCHAR	5
#define	PWCK_SHORT	6

/*
 *	Return codes for checkpassword() are:
 *
 *	PWCK_OK if <password> is ok to use
 *	PWCK_FAIL if something failed during the check process
 *	PWCK_NULL if <password> is the null string
 *	PWCK_OBVIOUS if <password> is too "obvious"
 *		(equals login name, host name, 'zzzz' )
 *	PWCK_FINGER if <password> is in the users' passwd/finger info
 *	PWCK_INDICT if <password> is in the dictionaries checked
 *	PWCK_ILLCHAR if <password> is lexically illegal
 *	PWCK_SHORT if <password> is too short
 */

/*
 *	Password checking peference block
 */
struct pwck_preferences {
	char	OneCaseOk,	/* Are single-case pwds acceptable */
		CtrlOk,		/* Are control characters acceptable */
		CharRunLen,	/* How long can run of characters be  */
		MinPwLen;	/* Minimum password length */
	char	*EgrepPath;	/* Path to the 'egrep' program */
};

/*
 *	Preference list
 */
IMPORT struct pwck_preferences	pwck_preferences;

/*
 *	List of control characters not allowed in passwords
 */
IMPORT char		pwck_illegalcc[];

/*
 *	List of dictionaries to check
 */
IMPORT char		*pwck_dicitonaries[];

