/* Copyright (C) The Internet Society (1998).  All Rights Reserved.
   
   This document and translations of it may be copied and furnished to
   others, and derivative works that comment on or otherwise explain it
   or assist in its implementation may be prepared, copied, published
   and distributed, in whole or in part, without restriction of any
   kind, provided that the above copyright notice and this paragraph are
   included on all such copies and derivative works.  However, this
   document itself may not be modified in any way, such as by removing
   the copyright notice or references to the Internet Society or other
   Internet organizations, except as needed for the purpose of
   developing Internet standards in which case the procedures for
   copyrights defined in the Internet Standards process must be
   followed, or as required to translate it into languages other than
   English.
   
   The limited permissions granted above are perpetual and will not be
   revoked by the Internet Society or its successors or assigns.
   
   This document and the information contained herein is provided on an
   "AS IS" basis and THE INTERNET SOCIETY AND THE INTERNET ENGINEERING
   TASK FORCE DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED, INCLUDING
   BUT NOT LIMITED TO ANY WARRANTY THAT THE USE OF THE INFORMATION
   HEREIN WILL NOT INFRINGE ANY RIGHTS OR ANY IMPLIED WARRANTIES OF
   MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
   */

#ifndef _DISTRIBUTION_H_
#define _DISTRIBUTION_H_

/* Returns the raw A^2 test statistic for n sorted samples
 * z[0] .. z[n-1], for z ~ Unif(0,1).
 */
extern double compute_A2(double z[], int n);

/* Returns the significance level associated with a A^2 test
 * statistic value of A2, assuming no parameters of the tested
 * distribution were estimated from the data.
 */
extern double A2_significance(double A2);

/* Returns the A^2 significance level for testing n observations
 * x[0] .. x[n-1] against an exponential distribution with the
 * given mean.
 *
 * SIDE EFFECT: the x[0..n-1] are sorted upon return.
 */
extern double exp_A2_known_mean(double x[], int n, double mean);

/* Returns the A^2 significance level for testing n observations
 * x[0] .. x[n-1] against the uniform distribution [min_val, max_val].
 *
 * SIDE EFFECT: the x[0..n-1] are sorted upon return.
 */
extern double unif_A2_known_range(double x[], int n,
				  double min_val, double max_val);


/* Returns a pseudo-random number distributed according to an
 * exponential distribution with the given mean.
 */
extern double random_exponential(double mean);
extern double random_uniform(double min, double max);

#endif /* _DISTRIBUTION_H_ */
