.TH LOADMAN 1  "1 Nov 1993"
.SH NAME
loadman \- visualise Ethernet load in real-time
.SH SYNOPSIS
.na
.B loadman
[
.B \-I
.I interface
] [
.B \-t
.I log-time
] [
.B \-f
.I log-filename
] [
.B \-wait
] 
.br
.ad
.SH DESCRIPTION
.LP
.I Loadman
is an X based utility which displays Ethernet load at
one second intervals. 
.I Loadman 
maintains a simple network history using packets 
promiscuously received on a local network interface. This history
is maintained using a sliding interval and so will maintain acurate load
and peak load figures.
.PP
.I Loadman 
is an implementation of the loadring algortihm for calculating network
bandwidth usage as described by Jeffry Mogul ["Efficient Use of Workstations
for Passive Monitoring of Local Area Networks." Proceedings of the ACM SIGCOMM 
1990 Symposium on Communications Architectures and Protocols]. As a result of 
this algorrithm we beleive that in the absence of dropped packets, 
.I Loadman 
is one of the most accurate and efficient workstation based load monitors
available today.
.PP
If 
.I Loadman 
is active, and the workstation becomes loaded, packets can be dropped.
This causes the load and average load figures become skewed. 
The percentage load figure becomes accurate again after one second of
drop-free run time but the average load figure remains skewed. 
.PP
If the data logging feature of
.I loadman
is used then the load, peak load, number of packets dropped and
the data and time
are written to the specified file at each interval.  If no output
file is specified then the data is written to 
.I stdout
.PP
This information is presented on a stripchart which
is updated once every second.  The chart is scaled in 10% intervals, with the
maximum bandwidth consumption being 60%.  The stripchart cannot be
modified in any way, it simply displays a history of overall network load.
.PP
.B Under Ultrix:
Non-root execution requires the super-user to invoke promiscuous-mode
operation via 
.IR pfconfig (8).
A suggested configuration is:
.PP
.in +.5i
.B /usr/etc/pfconfig \-a +promisc +copyall \-backlog 255
.PP
.SH OPTIONS
.IP "\fB\-I interface\fP" 5
 Use the specified interface (le0, ln0, ...)
.IP "\fB\-t time interval\fP" 5
 Specify the interval to update the log file at (in seconds)
.IP "\fB\-f <filename>\fP" 5
 Specify the log file to generate
.IP "\fB\-wait\fP" 5
 Disable packet waiting detection
.PP
.SH GRAPHICAL DISPLAY
.I Loadman
displays a stripchart widget that gives the network load over the past
second. 
Loadman generates and maintains three figures that are displayed
across the top of the stripchart.
In order from left to right these statistics are:
.PP
.in +.5i
.I Load:
The percentage usage of the network bandwidth over the past second.
.PP
.in +.5i
.I Average load:
The overall load average (bandwidth usage) calculated from the beginning
of execution.
.PP
.in +.5i
.I Peak load:
The highest traffic burst calculated from the beginning of execution.
.PP
.SH FILES
.IP \fI./Loadman.ad\fP 20
Applications default file for \fILoadman\fP.  Note that this file does not
require installation, but may be used to modify the \fILoadman\fP setup by
either :
\fIxrdb -merge Loadman.ad\fP
or copying to the system app-defaults area as
.B Loadman.
.SH BUGS
.PP 
None known. If any are found please send bug report to
.B netman@cs.curtin.edu.au
