/* packet-dcerpc-rs_repadm.c
 *
 * Routines for dcerpc Registry server administration operations.
 * Copyright 2002, Jaime Fournier <jafour1@yahoo.com>
 * This information is based off the released idl files from opengroup.
 * ftp://ftp.opengroup.org/pub/dce122/dce/src/security.tar.gz  security/idl/rs_repadm.idl
 *
 * $Id: packet-dcerpc-rs_repadm.c,v 1.2 2002/11/08 19:42:40 guy Exp $
 *
 * Ethereal - Network traffic analyzer
 * By Gerald Combs <gerald@ethereal.com>
 * Copyright 1998 Gerald Combs
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif


#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif

#include <string.h>

#include <glib.h>
#include <epan/packet.h>
#include "packet-dcerpc.h"


static int proto_rs_repadm = -1;
static int hf_rs_repadm_opnum = -1;


static gint ett_rs_repadm = -1;


static e_uuid_t uuid_rs_repadm = { 0x5b8c2fa8, 0xb60b, 0x11c9, { 0xbe, 0x0f, 0x08, 0x00, 0x1e, 0x01, 0x8f, 0xa0 } };
static guint16  ver_rs_repadm = 1.1;



	 
static dcerpc_sub_dissector rs_repadm_dissectors[] = {
    { 0, "rs_rep_admin_stop", NULL, NULL},
    { 1, "rs_rep_admin_maint", NULL, NULL},
    { 2, "rs_rep_admin_mkey", NULL, NULL},
    { 3, "rs_rep_admin_info", NULL, NULL},
    { 4, "rs_rep_admin_info_full", NULL, NULL},
    { 5, "rs_rep_admin_destroy", NULL, NULL},
    { 6, "rs_rep_admin_init_replica", NULL, NULL},
    { 7, "rs_rep_admin_change_master", NULL, NULL},
    { 8, "rs_rep_admin_become_master", NULL, NULL},
    { 9, "rs_rep_admin_become_slave", NULL, NULL},
    { 10, "rs_rep_admin_set_sw_rev", NULL, NULL},
    { 11, "rs_rep_admin_get_sw_vers_info", NULL, NULL},
    { 0, NULL, NULL, NULL }
};


static const value_string rs_repadm_opnum_vals[] = {
    { 0, "rs_rep_admin_stop" },
    { 1, "rs_rep_admin_maint" },
    { 2, "rs_rep_admin_mkey" },
    { 3, "rs_rep_admin_info" },
    { 4, "rs_rep_admin_info_full" },
    { 5, "rs_rep_admin_destroy" },
    { 6, "rs_rep_admin_init_replica" },
    { 7, "rs_rep_admin_change_master" },
    { 8, "rs_rep_admin_become_master" },
    { 9, "rs_rep_admin_become_slave" },
    { 10, "rs_rep_admin_set_sw_rev" },
    { 11, "rs_rep_admin_get_sw_vers_info" },
    { 0, NULL }
};


void
proto_register_rs_repadm (void)
{
	static hf_register_info hf[] = {
	{ &hf_rs_repadm_opnum,
		{ "Operation", "rs_repadmin.opnum", FT_UINT16, BASE_DEC, VALS(rs_repadm_opnum_vals), 0x0, "Operation", HFILL }}
	};

	static gint *ett[] = {
		&ett_rs_repadm,
	};
	proto_rs_repadm = proto_register_protocol ("Registry server administration operations.", "RS_REPADM", "rs_repadm");
	proto_register_field_array (proto_rs_repadm, hf, array_length (hf));
	proto_register_subtree_array (ett, array_length (ett));
}

void
proto_reg_handoff_rs_repadm (void)
{
	/* Register the protocol as dcerpc */
	dcerpc_init_uuid (proto_rs_repadm, ett_rs_repadm, &uuid_rs_repadm, ver_rs_repadm, rs_repadm_dissectors, hf_rs_repadm_opnum);
}
