/* packet-ppp.c
 * Routines for ppp packet disassembly
 *
 * Ethereal - Network traffic analyzer
 * By Gerald Combs <gerald@zing.org>
 *
 * This file created and by Mike Hall <mlh@io.com>
 * Copyright 1998
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include <gtk/gtk.h>
#include <stdio.h>
#include <pcap.h>

#include "packet.h"
#include "ethereal.h"

void
dissect_ppp( const u_char *pd, frame_data *fd, GtkTree *tree ) {
  GtkWidget *ti, *fh_tree;

  /* load the top pane info. This should be overwritten by
     the next protocol in the stack */
  if(fd->win_info[0]) {
    strcpy(fd->win_info[1], "N/A" );
    strcpy(fd->win_info[2], "N/A" );
    strcpy(fd->win_info[4], "PPP" );
  }

  /* populate a tree in the second pane with the status of the link
     layer (ie none) */
  if(tree) {
    ti = add_item_to_tree( GTK_WIDGET(tree), 0, 0,
			   "PPP (%d on link, %d captured)",
			   fd->pkt_len, fd->cap_len );
    fh_tree = gtk_tree_new();
    gtk_tree_item_set_subtree( GTK_TREE_ITEM(ti), fh_tree);
    add_item_to_tree(fh_tree, 0, 0, "No link information available");
  }

  if (pd[0] == 0xff && pd[1] == 0x03)
    dissect_ip(pd, 4, fd, tree);
  else
    dissect_ip(pd, 0, fd, tree);
}
    
