/* packet.h
 * Definitions for packet disassembly structures and routines
 *
 * Ethereal - Network traffic analyzer
 * By Gerald Combs <gerald@unicom.net>
 * Copyright 1998 Gerald Combs
 *
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef __PACKET_H__
#define __PACKET_H__

#define IEEE_802_3_MAX_LEN 1500
#define BYTE_VIEW_WIDTH    16

typedef struct _frame_data {
  guint32  pkt_len;         /* Packet length */
  guint32  cap_len;         /* Amount actually captured */
  guint32  secs;            /* Seconds */
  guint32  usecs;           /* Microseconds */
  long     file_off;        /* File offset */
  gchar   *win_info[5];        /* Packet list text */
} frame_data;

/* Utility routines used by packet*.c */
gchar*     ether_to_str(guint8 *);
gchar*     ip_to_str(guint8 *);
void       packet_hex_print(GtkText *, guint8 *, gint, gint, gint);
GtkWidget* add_item_to_tree(GtkWidget *, gint, gint, gchar *, ...);

/* Routines in packet.c */
void dissect_packet(const u_char *, frame_data *, GtkTree *);

/*
 * Routines in packet-*.c
 * Routines should take three args: packet data *, offset, frame_data *
 * They should never modify the packet data.
 */
void dissect_arp(const u_char *, int, frame_data *, GtkTree *);
void dissect_ip(const u_char *, int, frame_data *, GtkTree *);
void dissect_tcp(const u_char *, int, frame_data *, GtkTree *);
void dissect_udp(const u_char *, int, frame_data *, GtkTree *);

#endif /* packet.h */
