/* packet-udp.c
 * Routines for UDP packet disassembly
 *
 * Ethereal - Network traffic analyzer
 * By Gerald Combs <gerald@unicom.net>
 * Copyright 1998 Gerald Combs
 *
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include <gtk/gtk.h>

/* To do: do this correctly */
#define __FAVOR_BSD

#include <stdio.h>
#include <netinet/in.h>
#include <netinet/udp.h>

#include "packet.h"
#include "ethereal.h"

void
dissect_udp(const u_char *pd, int offset, frame_data *fd, GtkTree *tree) {
  struct udphdr *uh;
  guint16        uh_sport, uh_dport, uh_ulen, uh_sum;
  GtkWidget     *udp_tree, *ti;

  /* To do: Check for {cap len,pkt len} < struct len */
  uh = (struct udphdr *) &pd[offset];
  uh_sport = ntohs(uh->uh_sport);
  uh_dport = ntohs(uh->uh_dport);
  uh_ulen  = ntohs(uh->uh_ulen);
  uh_sum   = ntohs(uh->uh_sum);
  
  if (fd->win_info[0]) {
    strcpy(fd->win_info[3], "UDP");
    sprintf(fd->win_info[4], "Source port: %d  Destination port: %d",
      uh_sport, uh_dport);
  }
  
  if (tree) {
    ti = add_item_to_tree(GTK_WIDGET(tree), offset, 8,
      "User Datagram Protocol");
    udp_tree = gtk_tree_new();
    gtk_tree_item_set_subtree(GTK_TREE_ITEM(ti), udp_tree);
    add_item_to_tree(udp_tree, offset,     2, "Source port: %d", uh_sport);
    add_item_to_tree(udp_tree, offset + 2, 2, "Destination port: %d", uh_dport);
    add_item_to_tree(udp_tree, offset + 4, 2, "Length: %d", uh_ulen);
    add_item_to_tree(udp_tree, offset + 6, 2, "Checksum: 0x%04x", uh_sum);
  }
}
