/* packet-tcp.c
 * Routines for TCP packet disassembly
 *
 * Ethereal - Network traffic analyzer
 * By Gerald Combs <gerald@unicom.net>
 * Copyright 1998 Gerald Combs
 *
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include <gtk/gtk.h>

/* To do: do this correctly */
#define __FAVOR_BSD

#include <stdio.h>
#include <sys/socket.h>

#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <netinet/ip_var.h>
#include <netinet/tcp.h>

#include "packet.h"
#include "ethereal.h"

void
dissect_tcp(const u_char *pd, int offset, frame_data *fd, GtkTree *tree) {
  struct tcphdr  th;
  GtkWidget     *tcp_tree, *ti;

  /* To do: Check for {cap len,pkt len} < struct len */
  /* Avoids alignment problems on many architectures. */
  memcpy(&th, &pd[offset], sizeof(struct tcphdr));
  th.th_sport = ntohs(th.th_sport);
  th.th_dport = ntohs(th.th_dport);
  th.th_win   = ntohs(th.th_win);
  th.th_sum   = ntohs(th.th_sum);
  th.th_urp   = ntohs(th.th_urp);
  th.th_seq   = ntohl(th.th_seq);
  th.th_ack   = ntohl(th.th_ack);
  
  if (fd->win_info[0]) {
    strcpy(fd->win_info[3], "TCP");
    sprintf(fd->win_info[4], "Source port: %d  Destination port: %d",
      th.th_sport, th.th_dport);
  }
  
  if (tree) {
    ti = add_item_to_tree(GTK_WIDGET(tree), offset, 20,
      "Transmission Control Protocol");
    tcp_tree = gtk_tree_new();
    gtk_tree_item_set_subtree(GTK_TREE_ITEM(ti), tcp_tree);
    add_item_to_tree(tcp_tree, offset,      2, "Source port: %d", th.th_sport);
    add_item_to_tree(tcp_tree, offset +  2, 2, "Destination port: %d", th.th_dport);
    add_item_to_tree(tcp_tree, offset +  4, 4, "Sequence number: 0x%08x",
      th.th_seq);
    add_item_to_tree(tcp_tree, offset +  8, 4, "Acknowledgement number: 0x%08x",
      th.th_ack);
    add_item_to_tree(tcp_tree, offset + 14, 2, "Window size: %d", th.th_win);
    add_item_to_tree(tcp_tree, offset + 16, 2, "Checksum: 0x%04x", th.th_sum);
    add_item_to_tree(tcp_tree, offset + 18, 2, "Urgent pointer: 0x%04x",
      th.th_urp);
  }
}
