/* Driver template for the LEMON parser generator.
** Copyright 1991-1995 by D. Richard Hipp.
**
** This library is free software; you can redistribute it and/or
** modify it under the terms of the GNU Library General Public
** License as published by the Free Software Foundation; either
** version 2 of the License, or (at your option) any later version.
**
** This library is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** Library General Public License for more details.
**
** You should have received a copy of the GNU Library General Public
** License along with this library; if not, write to the
** Free Software Foundation, Inc., 59 Temple Place - Suite 330,
** Boston, MA  02111-1307, USA.
**
** Modified 1997 to make it suitable for use with makeheaders.
*/
/* First off, code is include which follows the "include" declaration
** in the input file. */
#include <stdio.h>
#line 3 "./grammar.lemon"

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "dfilter-int.h"
#include "syntax-tree.h"
#include "sttype-range.h"
#include "sttype-test.h"
#include "drange.h"

/* End of C code */

#line 39 "grammar.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/*
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands.
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash
**                       table.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    DfilterTOKENTYPE     is the data type used for minor tokens given
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is DfilterTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.
**    DfilterARGDECL       is a declaration of a 3rd argument to the
**                       parser, or null if there is no extra argument.
**    DfilterKRARGDECL     A version of DfilterARGDECL for K&R C.
**    DfilterANSIARGDECL   A version of DfilterARGDECL for ANSI C.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
/*  */
#define YYCODETYPE unsigned char
#define YYNOCODE 35
#define YYACTIONTYPE unsigned char
#define DfilterTOKENTYPE stnode_t*
typedef union {
  DfilterTOKENTYPE yy0;
  drange_node* yy25;
  GSList* yy26;
  test_op_t yy42;
  stnode_t* yy51;
  int yy69;
} YYMINORTYPE;
#define YYSTACKDEPTH 100
#define DfilterARGDECL ,dfw
#define DfilterXARGDECL dfwork_t *dfw;
#define DfilterANSIARGDECL ,dfwork_t *dfw
#define YYNSTATE 42
#define YYNRULE 31
#define YYERRORSYMBOL 27
#define YYERRSYMDT yy69
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)
/* Next is the action table.  Each entry in this table contains
**
**  +  An integer which is the number representing the look-ahead
**     token
**
**  +  An integer indicating what action to take.  Number (N) between
**     0 and YYNSTATE-1 mean shift the look-ahead and go to state N.
**     Numbers between YYNSTATE and YYNSTATE+YYNRULE-1 mean reduce by
**     rule N-YYNSTATE.  Number YYNSTATE+YYNRULE means that a syntax
**     error has occurred.  Number YYNSTATE+YYNRULE+1 means the parser
**     accepts its input.
**
**  +  A pointer to the next entry with the same hash value.
**
** The action table is really a series of hash tables.  Each hash
** table contains a number of entries which is a power of two.  The
** "state" table (which follows) contains information about the starting
** point and size of each hash table.
*/
struct yyActionEntry {
  YYCODETYPE   lookahead;   /* The value of the look-ahead token */
  YYACTIONTYPE action;      /* Action to take for this look-ahead */
  struct yyActionEntry *next; /* Next look-ahead with the same hash, or NULL */
};
static struct yyActionEntry yyActionTable[] = {
/* State 0 */
  {  32,   3, &yyActionTable[   2] }, /*          relation_test shift  3 */
  {  33,  74, 0                    }, /*               sentence accept */
  {   0,  43, 0                    }, /*                      $ reduce 1 */
  {   3,  14, 0                    }, /*                  FIELD shift  14 */
  {   7,   5, 0                    }, /*                 LPAREN shift  5 */
  {  21,  10, 0                    }, /*               TEST_NOT shift  10 */
  {  10,  28, 0                    }, /*                 STRING shift  28 */
  {  23,  29, &yyActionTable[   4] }, /*               UNPARSED shift  29 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  26,  12, &yyActionTable[   6] }, /*                 entity shift  12 */
  {YYNOCODE,0,0}, /* Unused */
  {  28,   1, 0                    }, /*                   expr shift  1 */
  {  29,   4, 0                    }, /*           logical_test shift  4 */
  {  30,  30, 0                    }, /*                  range shift  30 */
  {YYNOCODE,0,0}, /* Unused */
/* State 1 */
  {   0,  42, 0                    }, /*                      $ reduce 0 */
  {YYNOCODE,0,0}, /* Unused */
  {  22,   8, 0                    }, /*                TEST_OR shift  8 */
  {  11,   2, 0                    }, /*               TEST_AND shift  2 */
/* State 2 */
  {  32,   3, 0                    }, /*          relation_test shift  3 */
  {   7,   5, 0                    }, /*                 LPAREN shift  5 */
  {  10,  28, 0                    }, /*                 STRING shift  28 */
  {   3,  14, 0                    }, /*                  FIELD shift  14 */
  {YYNOCODE,0,0}, /* Unused */
  {  21,  10, 0                    }, /*               TEST_NOT shift  10 */
  {YYNOCODE,0,0}, /* Unused */
  {  23,  29, &yyActionTable[  21] }, /*               UNPARSED shift  29 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  26,  12, &yyActionTable[  22] }, /*                 entity shift  12 */
  {YYNOCODE,0,0}, /* Unused */
  {  28,  41, 0                    }, /*                   expr shift  41 */
  {  29,   4, 0                    }, /*           logical_test shift  4 */
  {  30,  30, 0                    }, /*                  range shift  30 */
  {YYNOCODE,0,0}, /* Unused */
/* State 3 */
  {YYNOCODE,0,0}, /* Unused */
/* State 4 */
  {YYNOCODE,0,0}, /* Unused */
/* State 5 */
  {  32,   3, 0                    }, /*          relation_test shift  3 */
  {   7,   5, 0                    }, /*                 LPAREN shift  5 */
  {  10,  28, 0                    }, /*                 STRING shift  28 */
  {   3,  14, 0                    }, /*                  FIELD shift  14 */
  {YYNOCODE,0,0}, /* Unused */
  {  21,  10, 0                    }, /*               TEST_NOT shift  10 */
  {YYNOCODE,0,0}, /* Unused */
  {  23,  29, &yyActionTable[  39] }, /*               UNPARSED shift  29 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  26,  12, &yyActionTable[  40] }, /*                 entity shift  12 */
  {YYNOCODE,0,0}, /* Unused */
  {  28,   6, 0                    }, /*                   expr shift  6 */
  {  29,   4, 0                    }, /*           logical_test shift  4 */
  {  30,  30, 0                    }, /*                  range shift  30 */
  {YYNOCODE,0,0}, /* Unused */
/* State 6 */
  {YYNOCODE,0,0}, /* Unused */
  {   9,   7, 0                    }, /*                 RPAREN shift  7 */
  {  22,   8, 0                    }, /*                TEST_OR shift  8 */
  {  11,   2, 0                    }, /*               TEST_AND shift  2 */
/* State 7 */
  {YYNOCODE,0,0}, /* Unused */
/* State 8 */
  {  32,   3, 0                    }, /*          relation_test shift  3 */
  {   7,   5, 0                    }, /*                 LPAREN shift  5 */
  {  10,  28, 0                    }, /*                 STRING shift  28 */
  {   3,  14, 0                    }, /*                  FIELD shift  14 */
  {YYNOCODE,0,0}, /* Unused */
  {  21,  10, 0                    }, /*               TEST_NOT shift  10 */
  {YYNOCODE,0,0}, /* Unused */
  {  23,  29, &yyActionTable[  60] }, /*               UNPARSED shift  29 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  26,  12, &yyActionTable[  61] }, /*                 entity shift  12 */
  {YYNOCODE,0,0}, /* Unused */
  {  28,   9, 0                    }, /*                   expr shift  9 */
  {  29,   4, 0                    }, /*           logical_test shift  4 */
  {  30,  30, 0                    }, /*                  range shift  30 */
  {YYNOCODE,0,0}, /* Unused */
/* State 9 */
  {YYNOCODE,0,0}, /* Unused */
/* State 10 */
  {  32,   3, 0                    }, /*          relation_test shift  3 */
  {   7,   5, 0                    }, /*                 LPAREN shift  5 */
  {  10,  28, 0                    }, /*                 STRING shift  28 */
  {   3,  14, 0                    }, /*                  FIELD shift  14 */
  {YYNOCODE,0,0}, /* Unused */
  {  21,  10, 0                    }, /*               TEST_NOT shift  10 */
  {YYNOCODE,0,0}, /* Unused */
  {  23,  29, &yyActionTable[  77] }, /*               UNPARSED shift  29 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  26,  12, &yyActionTable[  78] }, /*                 entity shift  12 */
  {YYNOCODE,0,0}, /* Unused */
  {  28,  11, 0                    }, /*                   expr shift  11 */
  {  29,   4, 0                    }, /*           logical_test shift  4 */
  {  30,  30, 0                    }, /*                  range shift  30 */
  {YYNOCODE,0,0}, /* Unused */
/* State 11 */
  {YYNOCODE,0,0}, /* Unused */
/* State 12 */
  {  16,  34, 0                    }, /*                TEST_GT shift  34 */
  {  17,  37, 0                    }, /*                TEST_LE shift  37 */
  {  18,  36, 0                    }, /*                TEST_LT shift  36 */
  {  19,  40, 0                    }, /*           TEST_MATCHES shift  40 */
  {  20,  33, 0                    }, /*                TEST_NE shift  33 */
  {  15,  35, 0                    }, /*                TEST_GE shift  35 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  12,  38, 0                    }, /*       TEST_BITWISE_AND shift  38 */
  {  13,  39, 0                    }, /*          TEST_CONTAINS shift  39 */
  {  14,  32, 0                    }, /*                TEST_EQ shift  32 */
  {  31,  13, &yyActionTable[  98] }, /*                rel_op2 shift  13 */
/* State 13 */
  {  10,  28, 0                    }, /*                 STRING shift  28 */
  {YYNOCODE,0,0}, /* Unused */
  {  26,  31, &yyActionTable[ 109] }, /*                 entity shift  31 */
  {   3,  14, 0                    }, /*                  FIELD shift  14 */
  {YYNOCODE,0,0}, /* Unused */
  {YYNOCODE,0,0}, /* Unused */
  {  30,  30, 0                    }, /*                  range shift  30 */
  {  23,  29, 0                    }, /*               UNPARSED shift  29 */
/* State 14 */
  {   6,  15, 0                    }, /*               LBRACKET shift  15 */
/* State 15 */
  {  24,  27, 0                    }, /*                 drnode shift  27 */
  {  25,  16, &yyActionTable[ 120] }, /*            drnode_list shift  16 */
  {   5,  20, &yyActionTable[ 121] }, /*                INTEGER shift  20 */
  {   1,  25, 0                    }, /*                  COLON shift  25 */
/* State 16 */
  {   8,  17, &yyActionTable[ 123] }, /*               RBRACKET shift  17 */
  {   2,  18, 0                    }, /*                  COMMA shift  18 */
/* State 17 */
  {YYNOCODE,0,0}, /* Unused */
/* State 18 */
  {  24,  19, 0                    }, /*                 drnode shift  19 */
  {   5,  20, &yyActionTable[ 127] }, /*                INTEGER shift  20 */
  {   1,  25, 0                    }, /*                  COLON shift  25 */
  {YYNOCODE,0,0}, /* Unused */
/* State 19 */
  {YYNOCODE,0,0}, /* Unused */
/* State 20 */
  {   4,  23, 0                    }, /*                 HYPHEN shift  23 */
  {   1,  21, 0                    }, /*                  COLON shift  21 */
/* State 21 */
  {   5,  22, 0                    }, /*                INTEGER shift  22 */
/* State 22 */
  {YYNOCODE,0,0}, /* Unused */
/* State 23 */
  {   5,  24, 0                    }, /*                INTEGER shift  24 */
/* State 24 */
  {YYNOCODE,0,0}, /* Unused */
/* State 25 */
  {   5,  26, 0                    }, /*                INTEGER shift  26 */
/* State 26 */
  {YYNOCODE,0,0}, /* Unused */
/* State 27 */
  {YYNOCODE,0,0}, /* Unused */
/* State 28 */
  {YYNOCODE,0,0}, /* Unused */
/* State 29 */
  {YYNOCODE,0,0}, /* Unused */
/* State 30 */
  {YYNOCODE,0,0}, /* Unused */
/* State 31 */
  {YYNOCODE,0,0}, /* Unused */
/* State 32 */
  {YYNOCODE,0,0}, /* Unused */
/* State 33 */
  {YYNOCODE,0,0}, /* Unused */
/* State 34 */
  {YYNOCODE,0,0}, /* Unused */
/* State 35 */
  {YYNOCODE,0,0}, /* Unused */
/* State 36 */
  {YYNOCODE,0,0}, /* Unused */
/* State 37 */
  {YYNOCODE,0,0}, /* Unused */
/* State 38 */
  {YYNOCODE,0,0}, /* Unused */
/* State 39 */
  {YYNOCODE,0,0}, /* Unused */
/* State 40 */
  {YYNOCODE,0,0}, /* Unused */
/* State 41 */
  {  22,   8, 0                    }, /*                TEST_OR shift  8 */
};

/* The state table contains information needed to look up the correct
** action in the action table, given the current state of the parser.
** Information needed includes:
**
**  +  A pointer to the start of the action hash table in yyActionTable.
**
**  +  A mask used to hash the look-ahead token.  The mask is an integer
**     which is one less than the size of the hash table.
**
**  +  The default action.  This is the action to take if no entry for
**     the given look-ahead is found in the action hash table.
*/
struct yyStateEntry {
  struct yyActionEntry *hashtbl; /* Start of the hash table in yyActionTable */
  int mask;                      /* Mask used for hashing the look-ahead */
  YYACTIONTYPE actionDefault;    /* Default action if look-ahead not found */
};
static struct yyStateEntry yyStateTable[] = {
  { &yyActionTable[0], 15, 73},
  { &yyActionTable[16], 3, 73},
  { &yyActionTable[20], 15, 73},
  { &yyActionTable[36], 0, 44},
  { &yyActionTable[37], 0, 45},
  { &yyActionTable[38], 15, 73},
  { &yyActionTable[54], 3, 73},
  { &yyActionTable[58], 0, 46},
  { &yyActionTable[59], 15, 73},
  { &yyActionTable[75], 0, 48},
  { &yyActionTable[76], 15, 73},
  { &yyActionTable[92], 0, 49},
  { &yyActionTable[93], 15, 50},
  { &yyActionTable[109], 7, 73},
  { &yyActionTable[117], 0, 51},
  { &yyActionTable[118], 3, 73},
  { &yyActionTable[122], 1, 73},
  { &yyActionTable[124], 0, 55},
  { &yyActionTable[125], 3, 73},
  { &yyActionTable[129], 0, 57},
  { &yyActionTable[130], 1, 62},
  { &yyActionTable[132], 0, 61},
  { &yyActionTable[133], 0, 58},
  { &yyActionTable[134], 0, 73},
  { &yyActionTable[135], 0, 59},
  { &yyActionTable[136], 0, 73},
  { &yyActionTable[137], 0, 60},
  { &yyActionTable[138], 0, 56},
  { &yyActionTable[139], 0, 52},
  { &yyActionTable[140], 0, 53},
  { &yyActionTable[141], 0, 54},
  { &yyActionTable[142], 0, 63},
  { &yyActionTable[143], 0, 64},
  { &yyActionTable[144], 0, 65},
  { &yyActionTable[145], 0, 66},
  { &yyActionTable[146], 0, 67},
  { &yyActionTable[147], 0, 68},
  { &yyActionTable[148], 0, 69},
  { &yyActionTable[149], 0, 70},
  { &yyActionTable[150], 0, 71},
  { &yyActionTable[151], 0, 72},
  { &yyActionTable[152], 0, 47},
};

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  int stateno;       /* The state-number */
  int major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
  YYMINORTYPE minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int idx;                            /* Index of top element in stack */
  int errcnt;                         /* Shifts left before out of the error */
  struct yyStackEntry *top;           /* Pointer to the top stack element */
  struct yyStackEntry stack[YYSTACKDEPTH];  /* The parser's stack */
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;

/*
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void DfilterTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}

/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static char *yyTokenName[] = {
  "$",             "COLON",         "COMMA",         "FIELD",       
  "HYPHEN",        "INTEGER",       "LBRACKET",      "LPAREN",      
  "RBRACKET",      "RPAREN",        "STRING",        "TEST_AND",    
  "TEST_BITWISE_AND",  "TEST_CONTAINS",  "TEST_EQ",       "TEST_GE",     
  "TEST_GT",       "TEST_LE",       "TEST_LT",       "TEST_MATCHES",
  "TEST_NE",       "TEST_NOT",      "TEST_OR",       "UNPARSED",    
  "drnode",        "drnode_list",   "entity",        "error",       
  "expr",          "logical_test",  "range",         "rel_op2",     
  "relation_test",  "sentence",    
};
#define YYTRACE(X) if( yyTraceFILE ) fprintf(yyTraceFILE,"%sReduce [%s].\n",yyTracePrompt,X);
#else
#define YYTRACE(X)
#endif

/*
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Dfilter and DfilterFree.
*/
void *DfilterAlloc(void *(*mallocProc)(gulong)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( sizeof(yyParser) );
  if( pParser ){
    pParser->idx = -1;
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(YYCODETYPE yymajor, YYMINORTYPE *yypminor){
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
    case 16:
    case 17:
    case 18:
    case 19:
    case 20:
    case 21:
    case 22:
    case 23:
#line 24 "./grammar.lemon"
{stnode_free((yypminor->yy0));}
#line 532 "grammar.c"
      break;
    case 24:
#line 47 "./grammar.lemon"
{drange_node_free((yypminor->yy25));}
#line 537 "grammar.c"
      break;
    case 25:
#line 50 "./grammar.lemon"
{drange_node_free_list((yypminor->yy26));}
#line 542 "grammar.c"
      break;
    case 26:
#line 33 "./grammar.lemon"
{stnode_free((yypminor->yy51));}
#line 547 "grammar.c"
      break;
    case 28:
#line 30 "./grammar.lemon"
{stnode_free((yypminor->yy51));}
#line 552 "grammar.c"
      break;
    case 29:
#line 39 "./grammar.lemon"
{stnode_free((yypminor->yy51));}
#line 557 "grammar.c"
      break;
    case 30:
#line 44 "./grammar.lemon"
{stnode_free((yypminor->yy51));}
#line 562 "grammar.c"
      break;
    case 32:
#line 36 "./grammar.lemon"
{stnode_free((yypminor->yy51));}
#line 567 "grammar.c"
      break;
    case 33:
#line 27 "./grammar.lemon"
{stnode_free((yypminor->yy51));}
#line 572 "grammar.c"
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;

  if( pParser->idx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->idx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[pParser->top->major]);
  }
#endif
  yymajor = pParser->top->major;
  yy_destructor( yymajor, &pParser->top->minor);
  pParser->idx--;
  pParser->top--;
  return yymajor;
}

/*
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from DfilterAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void DfilterFree(
  void *p,                 /* The parser to be deleted */
  void (*freeProc)(void *) /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->idx>=0 ) yy_pop_parser_stack(pParser);
  (*freeProc)(pParser);
}

/*
** Find the appropriate action for a parser given the look-ahead token.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_parser_action(
  yyParser *pParser,        /* The parser */
  int iLookAhead             /* The look-ahead token */
){
  struct yyStateEntry *pState;   /* Appropriate entry in the state table */
  struct yyActionEntry *pAction; /* Action appropriate for the look-ahead */

  /* if( pParser->idx<0 ) return YY_NO_ACTION;  */
  pState = &yyStateTable[pParser->top->stateno];
  if( iLookAhead!=YYNOCODE ){
    pAction = &pState->hashtbl[iLookAhead & pState->mask];
    while( pAction ){
      if( pAction->lookahead==iLookAhead ) return pAction->action;
      pAction = pAction->next;
    }
  }else if( pState->mask!=0 || pState->hashtbl->lookahead!=YYNOCODE ){
    return YY_NO_ACTION;
  }
  return pState->actionDefault;
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer ot the minor token to shift in */
){
  yypParser->idx++;
  yypParser->top++;
  if( yypParser->idx>=YYSTACKDEPTH ){
     yypParser->idx--;
     yypParser->top--;
#ifndef NDEBUG
     if( yyTraceFILE ){
       fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
     }
#endif
     while( yypParser->idx>=0 ) yy_pop_parser_stack(yypParser);
     /* Here code is inserted which will execute if the parser
     ** stack every overflows */
     return;
  }
  yypParser->top->stateno = yyNewState;
  yypParser->top->major = yyMajor;
  yypParser->top->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->idx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->idx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->stack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 33, 1 },
  { 33, 0 },
  { 28, 1 },
  { 28, 1 },
  { 28, 3 },
  { 29, 3 },
  { 29, 3 },
  { 29, 2 },
  { 29, 1 },
  { 26, 1 },
  { 26, 1 },
  { 26, 1 },
  { 26, 1 },
  { 30, 4 },
  { 25, 1 },
  { 25, 3 },
  { 24, 3 },
  { 24, 3 },
  { 24, 2 },
  { 24, 2 },
  { 24, 1 },
  { 32, 3 },
  { 31, 1 },
  { 31, 1 },
  { 31, 1 },
  { 31, 1 },
  { 31, 1 },
  { 31, 1 },
  { 31, 1 },
  { 31, 1 },
  { 31, 1 },
};

static void yy_accept();  /* Forward declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
  DfilterANSIARGDECL
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  struct yyStackEntry *yymsp;     /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  yymsp = yypParser->top;
  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **     YYTRACE("<text of the rule>");
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 0:
        YYTRACE("sentence ::= expr")
#line 115 "./grammar.lemon"
{ dfw->st_root = yymsp[0].minor.yy51; }
#line 764 "grammar.c"
        break;
      case 1:
        YYTRACE("sentence ::=")
#line 116 "./grammar.lemon"
{ dfw->st_root = NULL; }
#line 770 "grammar.c"
        break;
      case 2:
        YYTRACE("expr ::= relation_test")
#line 118 "./grammar.lemon"
{ yygotominor.yy51 = yymsp[0].minor.yy51; }
#line 776 "grammar.c"
        break;
      case 3:
        YYTRACE("expr ::= logical_test")
#line 119 "./grammar.lemon"
{ yygotominor.yy51 = yymsp[0].minor.yy51; }
#line 782 "grammar.c"
        break;
      case 4:
        YYTRACE("expr ::= LPAREN expr RPAREN")
#line 122 "./grammar.lemon"
{
	yygotominor.yy51 = yymsp[-1].minor.yy51;
}
#line 790 "grammar.c"
  yy_destructor(7,&yymsp[-2].minor);
  yy_destructor(9,&yymsp[0].minor);
        break;
      case 5:
        YYTRACE("logical_test ::= expr TEST_AND expr")
#line 129 "./grammar.lemon"
{
	yygotominor.yy51 = stnode_new(STTYPE_TEST, NULL);
	sttype_test_set2(yygotominor.yy51, TEST_OP_AND, yymsp[-2].minor.yy51, yymsp[0].minor.yy51);
}
#line 801 "grammar.c"
  yy_destructor(11,&yymsp[-1].minor);
        break;
      case 6:
        YYTRACE("logical_test ::= expr TEST_OR expr")
#line 135 "./grammar.lemon"
{
	yygotominor.yy51 = stnode_new(STTYPE_TEST, NULL);
	sttype_test_set2(yygotominor.yy51, TEST_OP_OR, yymsp[-2].minor.yy51, yymsp[0].minor.yy51);
}
#line 811 "grammar.c"
  yy_destructor(22,&yymsp[-1].minor);
        break;
      case 7:
        YYTRACE("logical_test ::= TEST_NOT expr")
#line 141 "./grammar.lemon"
{
	yygotominor.yy51 = stnode_new(STTYPE_TEST, NULL);
	sttype_test_set1(yygotominor.yy51, TEST_OP_NOT, yymsp[0].minor.yy51);
}
#line 821 "grammar.c"
  yy_destructor(21,&yymsp[-1].minor);
        break;
      case 8:
        YYTRACE("logical_test ::= entity")
#line 147 "./grammar.lemon"
{
	yygotominor.yy51 = stnode_new(STTYPE_TEST, NULL);
	sttype_test_set1(yygotominor.yy51, TEST_OP_EXISTS, yymsp[0].minor.yy51);
}
#line 831 "grammar.c"
        break;
      case 9:
        YYTRACE("entity ::= FIELD")
#line 155 "./grammar.lemon"
{ yygotominor.yy51 = yymsp[0].minor.yy0; }
#line 837 "grammar.c"
        break;
      case 10:
        YYTRACE("entity ::= STRING")
#line 156 "./grammar.lemon"
{ yygotominor.yy51 = yymsp[0].minor.yy0; }
#line 843 "grammar.c"
        break;
      case 11:
        YYTRACE("entity ::= UNPARSED")
#line 157 "./grammar.lemon"
{ yygotominor.yy51 = yymsp[0].minor.yy0; }
#line 849 "grammar.c"
        break;
      case 12:
        YYTRACE("entity ::= range")
#line 158 "./grammar.lemon"
{ yygotominor.yy51 = yymsp[0].minor.yy51; }
#line 855 "grammar.c"
        break;
      case 13:
        YYTRACE("range ::= FIELD LBRACKET drnode_list RBRACKET")
#line 163 "./grammar.lemon"
{
	yygotominor.yy51 = stnode_new(STTYPE_RANGE, NULL);
	sttype_range_set(yygotominor.yy51, yymsp[-3].minor.yy0, yymsp[-1].minor.yy26);

	/* Delete the list, but not the drange_nodes that
	 * the list contains. */
	g_slist_free(yymsp[-1].minor.yy26);
}
#line 868 "grammar.c"
  yy_destructor(6,&yymsp[-2].minor);
  yy_destructor(8,&yymsp[0].minor);
        break;
      case 14:
        YYTRACE("drnode_list ::= drnode")
#line 173 "./grammar.lemon"
{
	yygotominor.yy26 = g_slist_append(NULL, yymsp[0].minor.yy25);
}
#line 878 "grammar.c"
        break;
      case 15:
        YYTRACE("drnode_list ::= drnode_list COMMA drnode")
#line 178 "./grammar.lemon"
{
	yygotominor.yy26 = g_slist_append(yymsp[-2].minor.yy26, yymsp[0].minor.yy25);
}
#line 886 "grammar.c"
  yy_destructor(2,&yymsp[-1].minor);
        break;
      case 16:
        YYTRACE("drnode ::= INTEGER COLON INTEGER")
#line 184 "./grammar.lemon"
{
	yygotominor.yy25 = drange_node_new();
	drange_node_set_start_offset(yygotominor.yy25, stnode_value(yymsp[-2].minor.yy0));
	drange_node_set_length(yygotominor.yy25, stnode_value(yymsp[0].minor.yy0));
	
	stnode_free(yymsp[-2].minor.yy0);
	stnode_free(yymsp[0].minor.yy0);
}
#line 900 "grammar.c"
  yy_destructor(1,&yymsp[-1].minor);
        break;
      case 17:
        YYTRACE("drnode ::= INTEGER HYPHEN INTEGER")
#line 195 "./grammar.lemon"
{
	yygotominor.yy25 = drange_node_new();
	drange_node_set_start_offset(yygotominor.yy25, stnode_value(yymsp[-2].minor.yy0));
	drange_node_set_end_offset(yygotominor.yy25, stnode_value(yymsp[0].minor.yy0));
	
	stnode_free(yymsp[-2].minor.yy0);
	stnode_free(yymsp[0].minor.yy0);
}
#line 914 "grammar.c"
  yy_destructor(4,&yymsp[-1].minor);
        break;
      case 18:
        YYTRACE("drnode ::= COLON INTEGER")
#line 207 "./grammar.lemon"
{
	yygotominor.yy25 = drange_node_new();
	drange_node_set_start_offset(yygotominor.yy25, 0);
	drange_node_set_length(yygotominor.yy25, stnode_value(yymsp[0].minor.yy0));

	stnode_free(yymsp[0].minor.yy0);
}
#line 927 "grammar.c"
  yy_destructor(1,&yymsp[-1].minor);
        break;
      case 19:
        YYTRACE("drnode ::= INTEGER COLON")
#line 217 "./grammar.lemon"
{
	yygotominor.yy25 = drange_node_new();
	drange_node_set_start_offset(yygotominor.yy25, stnode_value(yymsp[-1].minor.yy0));
	drange_node_set_to_the_end(yygotominor.yy25);

	stnode_free(yymsp[-1].minor.yy0);
}
#line 940 "grammar.c"
  yy_destructor(1,&yymsp[0].minor);
        break;
      case 20:
        YYTRACE("drnode ::= INTEGER")
#line 227 "./grammar.lemon"
{
	yygotominor.yy25 = drange_node_new();
	drange_node_set_start_offset(yygotominor.yy25, stnode_value(yymsp[0].minor.yy0));
	drange_node_set_length(yygotominor.yy25, 1);

	stnode_free(yymsp[0].minor.yy0);
}
#line 953 "grammar.c"
        break;
      case 21:
        YYTRACE("relation_test ::= entity rel_op2 entity")
#line 239 "./grammar.lemon"
{
	yygotominor.yy51 = stnode_new(STTYPE_TEST, NULL);
	sttype_test_set2(yygotominor.yy51, yymsp[-1].minor.yy42, yymsp[-2].minor.yy51, yymsp[0].minor.yy51);
}
#line 962 "grammar.c"
        break;
      case 22:
        YYTRACE("rel_op2 ::= TEST_EQ")
#line 244 "./grammar.lemon"
{ yygotominor.yy42 = TEST_OP_EQ; }
#line 968 "grammar.c"
  yy_destructor(14,&yymsp[0].minor);
        break;
      case 23:
        YYTRACE("rel_op2 ::= TEST_NE")
#line 245 "./grammar.lemon"
{ yygotominor.yy42 = TEST_OP_NE; }
#line 975 "grammar.c"
  yy_destructor(20,&yymsp[0].minor);
        break;
      case 24:
        YYTRACE("rel_op2 ::= TEST_GT")
#line 246 "./grammar.lemon"
{ yygotominor.yy42 = TEST_OP_GT; }
#line 982 "grammar.c"
  yy_destructor(16,&yymsp[0].minor);
        break;
      case 25:
        YYTRACE("rel_op2 ::= TEST_GE")
#line 247 "./grammar.lemon"
{ yygotominor.yy42 = TEST_OP_GE; }
#line 989 "grammar.c"
  yy_destructor(15,&yymsp[0].minor);
        break;
      case 26:
        YYTRACE("rel_op2 ::= TEST_LT")
#line 248 "./grammar.lemon"
{ yygotominor.yy42 = TEST_OP_LT; }
#line 996 "grammar.c"
  yy_destructor(18,&yymsp[0].minor);
        break;
      case 27:
        YYTRACE("rel_op2 ::= TEST_LE")
#line 249 "./grammar.lemon"
{ yygotominor.yy42 = TEST_OP_LE; }
#line 1003 "grammar.c"
  yy_destructor(17,&yymsp[0].minor);
        break;
      case 28:
        YYTRACE("rel_op2 ::= TEST_BITWISE_AND")
#line 250 "./grammar.lemon"
{ yygotominor.yy42 = TEST_OP_BITWISE_AND; }
#line 1010 "grammar.c"
  yy_destructor(12,&yymsp[0].minor);
        break;
      case 29:
        YYTRACE("rel_op2 ::= TEST_CONTAINS")
#line 251 "./grammar.lemon"
{ yygotominor.yy42 = TEST_OP_CONTAINS; }
#line 1017 "grammar.c"
  yy_destructor(13,&yymsp[0].minor);
        break;
      case 30:
        YYTRACE("rel_op2 ::= TEST_MATCHES")
#line 252 "./grammar.lemon"
{ yygotominor.yy42 = TEST_OP_MATCHES; }
#line 1024 "grammar.c"
  yy_destructor(19,&yymsp[0].minor);
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->idx -= yysize;
  yypParser->top -= yysize;
  yyact = yy_find_parser_action(yypParser,yygoto);
  if( yyact < YYNSTATE ){
    yy_shift(yypParser,yyact,yygoto,&yygotominor);
  }else if( yyact == YYNSTATE + YYNRULE + 1 ){
    yy_accept(yypParser DfilterARGDECL);
  }
}

/*
** The following code executes when the parse fails
*/
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
  DfilterANSIARGDECL              /* Extra arguments (if any) */
){
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->idx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
#line 102 "./grammar.lemon"

	dfw->syntax_error = TRUE;

#line 1059 "grammar.c"
}

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser _U_,       /* The parser */
  int yymajor _U_,               /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
  DfilterANSIARGDECL _U_           /* Extra arguments (if any) */
){
#define TOKEN (yyminor.yy0)
#line 54 "./grammar.lemon"


	header_field_info	*hfinfo;

	if (!TOKEN) {
		dfilter_fail("Unexpected end of filter string.");
		return;
	}

	switch(stnode_type_id(TOKEN)) {
	        case STTYPE_UNINITIALIZED:
			dfilter_fail("Syntax error.");
			break;
		case STTYPE_TEST:
			dfilter_fail("Syntax error, TEST.");
			break;
		case STTYPE_STRING:
			dfilter_fail("The string \"%s\" was unexpected in this context.",
				stnode_data(TOKEN));
			break;
		case STTYPE_UNPARSED:
			dfilter_fail("\"%s\" was unexpected in this context.",
				stnode_data(TOKEN));
			break;
		case STTYPE_INTEGER:
			dfilter_fail("The integer %u was unexpected in this context.",
				stnode_value(TOKEN));
			break;
		case STTYPE_FIELD:
			hfinfo = stnode_data(TOKEN);
			dfilter_fail("Syntax error near \"%s\".", hfinfo->abbrev);
			break;

		/* These aren't handed to use as terminal tokens from
		   the scanner, so was can assert that we'll never
		   see them here. */
		case STTYPE_NUM_TYPES:
		case STTYPE_RANGE:
		case STTYPE_FVALUE:
			g_assert_not_reached();
			break;
	}

#line 1116 "grammar.c"
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
  DfilterANSIARGDECL _U_          /* Extra arguments (if any) */
){
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->idx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "DfilterAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Dfilter(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  DfilterTOKENTYPE yyminor       /* The value for the token */
  DfilterANSIARGDECL
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->idx<0 ){
    if( yymajor==0 ) return;
    yypParser->idx = 0;
    yypParser->errcnt = -1;
    yypParser->top = &yypParser->stack[0];
    yypParser->top->stateno = 0;
    yypParser->top->major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_parser_action(yypParser,yymajor);
    if( yyact<YYNSTATE ){
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->errcnt--;
      if( yyendofinput && yypParser->idx>=0 ){
        yymajor = 0;
      }else{
        yymajor = YYNOCODE;
      }
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE DfilterARGDECL);
    }else if( yyact == YY_ERROR_ACTION ){
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->errcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion DfilterARGDECL);
      }
      if( yypParser->top->major==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->idx >= 0 &&
          yypParser->top->major != YYERRORSYMBOL &&
          (yyact = yy_find_parser_action(yypParser,YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->idx < 0 || yymajor==0 ){
          yy_destructor(yymajor,&yyminorunion);
          yy_parse_failed(yypParser DfilterARGDECL);
          yymajor = YYNOCODE;
        }else if( yypParser->top->major!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->errcnt = 3;
      yyerrorhit = 1;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->errcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion DfilterARGDECL);
      }
      yypParser->errcnt = 3;
      yy_destructor(yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser DfilterARGDECL);
      }
      yymajor = YYNOCODE;
#endif
    }else{
      yy_accept(yypParser DfilterARGDECL);
      yymajor = YYNOCODE;
    }
  }while( yymajor!=YYNOCODE && yypParser->idx>=0 );
  return;
}
