#
#    Copyright 1999,2000 by the Purdue Research Foundation for CERIAS (the
#    Center for Education and Research in Information Assurance and
#    Security).  All rights reserved.  This work may be used for
#    non-profit educational and research purposes only.  Any copies made
#    of this file or portions of its contents must include this copyright
#    statement.  For information on reuse, licensing, or copying, contact
#    <cerias-info@cerias.purdue.edu>.
#
#    This software is experimental in nature and is provided without any
#    express or implied warranties, including, without limitation, the
#    implied warranties of merchantability and fitness for any particular
#    purpose.
#
#  $Id: percent.pat,v 1.4 2000/01/31 03:56:30 flack Exp $
#
#  Patches ANTLR so grammar identifiers (terminals and nonterminals) can be
#  any case, include valid Java identifier symbols like $ (but nothing outside
#  the Basic Latin Unicode block yet), and terminals are distinguished from
#  nonterminals by a % prefix that isn't considered part of the name.
#
#  Chapman Flack, flack@cs.purdue.edu
#

*** antlr/antlr.g	Sun Jan 30 22:03:53 2000
--- antlr/antlr.g	Sun Jan 30 22:03:54 2000
***************
*** 992,1005 ****
  
  TOKEN_REF
  options { testLiterals = true; }
! 	:	'A'..'Z'
  		(	// scarf as many letters/numbers as you can
  			options {
  				warnWhenFollowAmbig=false;
  			}
  		:
! 			'a'..'z'|'A'..'Z'|'_'|'0'..'9'
  		)*
  	;
  
  // we get a warning here when looking for options '{', but it works right
--- 992,1006 ----
  
  TOKEN_REF
  options { testLiterals = true; }
! 	:	'%'
  		(	// scarf as many letters/numbers as you can
  			options {
  				warnWhenFollowAmbig=false;
  			}
  		:
! 			'a'..'z'|'A'..'Z'|'_'|'$'|'0'..'9'
  		)*
+ 		{ setText( Tool.stripFront( getText(), '%')); }
  	;
  
  // we get a warning here when looking for options '{', but it works right
***************
*** 1030,1042 ****
  {
  	t = RULE_REF;
  }
! 	:	'a'..'z'
  		(	// scarf as many letters/numbers as you can
  			options {
  				warnWhenFollowAmbig=false;
  			}
  		:
! 			'a'..'z'|'A'..'Z'|'_'|'0'..'9'
  		)*
  		{t = testLiteralsTable(t);}
  	;
--- 1031,1043 ----
  {
  	t = RULE_REF;
  }
! 	:	('a'..'z'|'A'..'Z'|'_')
  		(	// scarf as many letters/numbers as you can
  			options {
  				warnWhenFollowAmbig=false;
  			}
  		:
! 			'a'..'z'|'A'..'Z'|'_'|'$'|'0'..'9'
  		)*
  		{t = testLiteralsTable(t);}
  	;
*** antlr/preprocessor/preproc.g	Sun Jan 30 22:03:54 2000
--- antlr/preprocessor/preproc.g	Sun Jan 30 22:03:54 2000
***************
*** 252,258 ****
  options {
  	testLiterals=true;
  }
! 	:	('a'..'z'|'A'..'Z'|'_') ('a'..'z'|'A'..'Z'|'_'|'0'..'9')*
  	;
  
  ASSIGN_RHS
--- 252,258 ----
  options {
  	testLiterals=true;
  }
! 	:	('%')?('a'..'z'|'A'..'Z'|'_') ('a'..'z'|'A'..'Z'|'_'|'$'|'0'..'9')*
  	;
  
  ASSIGN_RHS
