/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;

public class DataByteOutputStream
extends ByteArrayOutputStream {
    public void writeByte(int n) {
        this.write(n);
    }

    public void writeShort(int n) {
        this.write(n >>> 8 & 0xFF);
        this.write(n & 0xFF);
    }

    public void writeInt(int n) {
        this.write(n >>> 24 & 0xFF);
        this.write(n >>> 16 & 0xFF);
        this.write(n >>> 8 & 0xFF);
        this.write(n & 0xFF);
    }

    public void writeLong(long l) {
        this.write((int)(l >>> 56) & 0xFF);
        this.write((int)(l >>> 48) & 0xFF);
        this.write((int)(l >>> 40) & 0xFF);
        this.write((int)(l >>> 32) & 0xFF);
        this.write((int)(l >>> 24) & 0xFF);
        this.write((int)(l >>> 16) & 0xFF);
        this.write((int)(l >>> 8) & 0xFF);
        this.write((int)l & 0xFF);
    }

    public void writeString(String string) {
        try {
            byte[] byArray = string.getBytes();
            this.write(byArray.length);
            this.write(byArray);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void writeBigInteger(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        try {
            if (byArray[0] == 0) {
                this.write(byArray, 1, byArray.length - 1);
            } else {
                this.write(byArray);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void writeShortAt(int n, int n2) throws IllegalArgumentException {
        if (n2 < 0 || n2 > this.count) {
            throw new IllegalArgumentException(n2 + " out of range");
        }
        int n3 = this.count;
        this.count = n2;
        this.writeShort(n);
        this.count = n3;
    }

    public int getPos() {
        return this.count;
    }

    public DataByteOutputStream(int n) {
        super(n);
    }

    public DataByteOutputStream() {
    }
}

