/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import org.xbill.DNS.Cache;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.FindServer;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.SetResponse;
import org.xbill.DNS.Type;

public final class dns {
    private static Resolver res;
    private static Cache cache;
    private static Name[] searchPath;
    private static boolean searchPathSet;

    private static synchronized void initialize() {
        if (res == null) {
            try {
                dns.setResolver(new ExtendedResolver());
            }
            catch (UnknownHostException unknownHostException) {
                System.out.println("Failed to initialize resolver");
                System.exit(-1);
            }
        }
        if (!searchPathSet) {
            searchPath = FindServer.searchPath();
        }
        if (cache == null) {
            cache = new Cache();
        }
    }

    static boolean matchType(short s, short s2) {
        return s == 255 || s2 == 255 || s == s2;
    }

    public static String inaddrString(InetAddress inetAddress) {
        byte[] byArray = inetAddress.getAddress();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 3;
        while (n >= 0) {
            stringBuffer.append(byArray[n] & 0xFF);
            stringBuffer.append(".");
            --n;
        }
        stringBuffer.append("IN-ADDR.ARPA.");
        return stringBuffer.toString();
    }

    public static String inaddrString(String string) {
        InetAddress inetAddress;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
        return dns.inaddrString(inetAddress);
    }

    public static synchronized void setResolver(Resolver resolver) {
        res = resolver;
    }

    public static synchronized Resolver getResolver() {
        return res;
    }

    public static synchronized void setSearchPath(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            searchPath = null;
        } else {
            searchPath = new Name[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                dns.searchPath[n] = new Name(stringArray[n]);
                ++n;
            }
        }
        searchPathSet = true;
    }

    public static synchronized Cache getCache() {
        return cache;
    }

    private static Record[] lookup(Name name, short s, short s2, byte by) {
        Record[] recordArray;
        int n = 0;
        int n2 = 0;
        SetResponse setResponse = cache.lookupRecords(name, s, s2, by);
        if (setResponse.isSuccessful()) {
            RRset[] rRsetArray = setResponse.answers();
            n = 0;
            int n3 = 0;
            while (n3 < rRsetArray.length) {
                n += rRsetArray[n3].size();
                ++n3;
            }
            recordArray = new Record[n];
            n3 = 0;
            while (n3 < rRsetArray.length) {
                Enumeration enumeration = rRsetArray[n3].rrs();
                while (enumeration.hasMoreElements()) {
                    Record record = (Record)enumeration.nextElement();
                    recordArray[n2++] = record;
                }
                ++n3;
            }
        } else {
            Record record;
            Message message;
            if (setResponse.isNegative()) {
                return null;
            }
            Record record2 = Record.newRecord(name, s, s2);
            Message message2 = Message.newQuery(record2);
            try {
                message = res.send(message2);
            }
            catch (Exception exception) {
                return null;
            }
            short s3 = message.getHeader().getRcode();
            if (s3 == 0 || s3 == 3) {
                cache.addMessage(message);
            }
            if (s3 != 0) {
                return null;
            }
            Enumeration enumeration = message.getSection(1);
            while (enumeration.hasMoreElements()) {
                record = (Record)enumeration.nextElement();
                if (!dns.matchType(record.getType(), s)) continue;
                ++n;
            }
            if (n == 0) {
                return null;
            }
            recordArray = new Record[n];
            enumeration = message.getSection(1);
            while (enumeration.hasMoreElements()) {
                record = (Record)enumeration.nextElement();
                if (!dns.matchType(record.getType(), s)) continue;
                recordArray[n2++] = record;
            }
        }
        return recordArray;
    }

    public static Record[] getRecords(String string, short s, short s2, byte by) {
        Record[] recordArray = null;
        Name name = new Name(string);
        if (!Type.isRR(s) && s != 255) {
            return null;
        }
        dns.initialize();
        if (searchPath == null || name.isQualified()) {
            recordArray = dns.lookup(name, s, s2, by);
        } else {
            int n = 0;
            while (n < searchPath.length) {
                recordArray = dns.lookup(new Name(string, searchPath[n]), s, s2, by);
                if (recordArray != null) break;
                ++n;
            }
        }
        return recordArray;
    }

    public static Record[] getRecords(String string, short s, short s2) {
        return dns.getRecords(string, s, s2, (byte)2);
    }

    public static Record[] getAnyRecords(String string, short s, short s2) {
        return dns.getRecords(string, s, s2, (byte)1);
    }

    public static Record[] getRecords(String string, short s) {
        return dns.getRecords(string, s, (short)1, (byte)2);
    }

    public static Record[] getAnyRecords(String string, short s) {
        return dns.getRecords(string, s, (short)1, (byte)1);
    }

    public static Record[] getRecordsByAddress(String string, short s) {
        String string2 = dns.inaddrString(string);
        return dns.getRecords(string2, s, (short)1, (byte)2);
    }

    public static Record[] getAnyRecordsByAddress(String string, short s) {
        String string2 = dns.inaddrString(string);
        return dns.getRecords(string2, s, (short)1, (byte)1);
    }

    private dns() {
    }
}

