/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.util.Vector;
import org.xbill.DNS.CNAMERecord;
import org.xbill.DNS.RRset;

public class SetResponse {
    static final byte UNKNOWN = 0;
    static final byte NEGATIVE = 1;
    static final byte NXDOMAIN = 2;
    static final byte NODATA = 3;
    static final byte PARTIAL = 4;
    static final byte SUCCESSFUL = 5;
    private byte type;
    private Object data;
    private Vector backtrace;

    void set(byte by, Object object) {
        this.type = by;
        this.data = object;
    }

    void addRRset(RRset rRset) {
        if (this.data == null) {
            this.data = new Vector();
        }
        Vector vector = (Vector)this.data;
        vector.addElement(rRset);
    }

    void addCNAME(CNAMERecord cNAMERecord) {
        if (this.backtrace == null) {
            this.backtrace = new Vector();
        }
        this.backtrace.insertElementAt(cNAMERecord, 0);
    }

    public boolean isUnknown() {
        return this.type == 0;
    }

    public boolean isNegative() {
        return this.type == 1;
    }

    public boolean isNXDOMAIN() {
        return this.type == 2;
    }

    public boolean isNODATA() {
        return this.type == 3;
    }

    public boolean isPartial() {
        return this.type == 4;
    }

    public boolean isSuccessful() {
        return this.type == 5;
    }

    public RRset[] answers() {
        if (this.type != 5) {
            return null;
        }
        Vector vector = (Vector)this.data;
        RRset[] rRsetArray = new RRset[vector.size()];
        int n = 0;
        while (n < rRsetArray.length) {
            rRsetArray[n] = (RRset)vector.elementAt(n);
            ++n;
        }
        return rRsetArray;
    }

    public CNAMERecord partial() {
        if (this.type != 5) {
            return null;
        }
        return (CNAMERecord)this.data;
    }

    public Vector backtrace() {
        return this.backtrace;
    }

    public String toString() {
        switch (this.type) {
            case 0: {
                return "unknown";
            }
            case 1: {
                return "negative";
            }
            case 2: {
                return "NXDOMAIN";
            }
            case 3: {
                return "NODATA";
            }
            case 4: {
                return "partial: reached " + this.data;
            }
            case 5: {
                return "successful";
            }
        }
        return null;
    }

    private SetResponse() {
    }

    SetResponse(byte by, Object object) {
        this.type = by;
        this.data = object;
    }

    SetResponse(byte by) {
        this(by, null);
    }
}

