/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import org.xbill.DNS.Compression;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;
import org.xbill.DNS.utils.MyStringTokenizer;

public class SRVRecord
extends Record {
    private short priority;
    private short weight;
    private short port;
    private Name target;

    public String toString() {
        StringBuffer stringBuffer = this.toStringNoData();
        if (this.target != null) {
            stringBuffer.append(this.priority);
            stringBuffer.append(" ");
            stringBuffer.append(this.weight);
            stringBuffer.append(" ");
            stringBuffer.append(this.port);
            stringBuffer.append(" ");
            stringBuffer.append(this.target);
        }
        return stringBuffer.toString();
    }

    public short getPriority() {
        return this.priority;
    }

    public short getWeight() {
        return this.weight;
    }

    public short getPort() {
        return this.port;
    }

    public Name getTarget() {
        return this.target;
    }

    void rrToWire(DataByteOutputStream dataByteOutputStream, Compression compression) throws IOException {
        if (this.target == null) {
            return;
        }
        dataByteOutputStream.writeShort(this.priority);
        dataByteOutputStream.writeShort(this.weight);
        dataByteOutputStream.writeShort(this.port);
        this.target.toWire(dataByteOutputStream, null);
    }

    void rrToWireCanonical(DataByteOutputStream dataByteOutputStream) throws IOException {
        if (this.target == null) {
            return;
        }
        dataByteOutputStream.writeShort(this.priority);
        dataByteOutputStream.writeShort(this.weight);
        dataByteOutputStream.writeShort(this.port);
        this.target.toWireCanonical(dataByteOutputStream);
    }

    private SRVRecord() {
    }

    public SRVRecord(Name name, short s, int n, int n2, int n3, int n4, Name name2) {
        super(name, (short)33, s, n);
        this.priority = (short)n2;
        this.weight = (short)n2;
        this.port = (short)n2;
        this.target = name2;
    }

    SRVRecord(Name name, short s, int n, int n2, DataByteInputStream dataByteInputStream, Compression compression) throws IOException {
        super(name, (short)33, s, n);
        if (dataByteInputStream == null) {
            return;
        }
        this.priority = (short)dataByteInputStream.readUnsignedShort();
        this.weight = (short)dataByteInputStream.readUnsignedShort();
        this.port = (short)dataByteInputStream.readUnsignedShort();
        this.target = new Name(dataByteInputStream, compression);
    }

    SRVRecord(Name name, short s, int n, MyStringTokenizer myStringTokenizer, Name name2) throws IOException {
        super(name, (short)33, s, n);
        this.priority = Short.parseShort(myStringTokenizer.nextToken());
        this.weight = Short.parseShort(myStringTokenizer.nextToken());
        this.port = Short.parseShort(myStringTokenizer.nextToken());
        this.target = new Name(myStringTokenizer.nextToken(), name2);
    }
}

