/*
 * Decompiled with CFR 0.152.
 */
package org.doit.util;

import org.doit.util.ThreadPool;

public class ReusableThread
extends Thread {
    private ThreadPool pool = null;
    private Runnable runnable = null;
    private boolean alive = true;
    private long lastrun = 0L;
    private int used = 0;

    public synchronized void setRunnable(Runnable runnable) {
        this.runnable = runnable;
        this.notify();
    }

    public synchronized void terminate() {
        this.alive = false;
        this.notify();
    }

    public long getLastRunTime() {
        return this.lastrun;
    }

    public int useCount() {
        return this.used;
    }

    public void run() {
        while (this.alive) {
            this.setName("ReusableThread: idle");
            while (this.runnable == null && this.alive) {
                ReusableThread reusableThread = this;
                synchronized (reusableThread) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (!this.alive) continue;
            this.setName("ReusableThread: busy");
            this.setPriority(5);
            this.lastrun = System.currentTimeMillis();
            ++this.used;
            this.runnable.run();
            this.runnable = null;
            this.pool.put(this);
        }
    }

    public ReusableThread(ThreadPool threadPool) {
        this.pool = threadPool;
    }
}

