/*
 * Decompiled with CFR 0.152.
 */
package org.doit.muffin.filter;

import java.io.IOException;
import org.doit.html.Tag;
import org.doit.html.Token;
import org.doit.io.ByteArray;
import org.doit.io.InputObjectStream;
import org.doit.io.OutputObjectStream;
import org.doit.muffin.ContentFilter;
import org.doit.muffin.FilterException;
import org.doit.muffin.Prefs;
import org.doit.muffin.Reply;
import org.doit.muffin.ReplyFilter;
import org.doit.muffin.Request;
import org.doit.muffin.RequestFilter;
import org.doit.muffin.filter.NoThanks;

public class NoThanksFilter
implements ContentFilter,
RequestFilter,
ReplyFilter {
    NoThanks factory;
    Prefs prefs;
    InputObjectStream in = null;
    OutputObjectStream out = null;
    Request request = null;
    Reply reply = null;

    public void setPrefs(Prefs prefs) {
        this.prefs = prefs;
    }

    public void filter(Request request) throws FilterException {
        String string = request.getURL();
        String string2 = this.factory.redirect(string);
        if (string2 != null) {
            this.factory.report(request, "redirect to " + string2);
            request.setURL(string2);
            return;
        }
        if (this.factory.isKilled(string)) {
            this.factory.report(request, "rejected " + string);
            throw new FilterException("NoThanks URL " + string + " rejected");
        }
        this.factory.processHeaders(request, request);
    }

    public void filter(Reply reply) throws FilterException {
        String string = reply.getContentType();
        if (string != null && this.factory.killContent(string)) {
            this.factory.report(this.request, "rejected " + string);
            throw new FilterException("NoThanks content-type " + string + " rejected");
        }
        this.factory.processHeaders(this.request, reply);
    }

    public boolean needsFiltration(Request request, Reply reply) {
        this.request = request;
        this.reply = reply;
        String string = reply.getContentType();
        return string != null && (string.startsWith("text/html") || string.startsWith("application/x-javascript"));
    }

    public void setInputObjectStream(InputObjectStream inputObjectStream) {
        this.in = inputObjectStream;
    }

    public void setOutputObjectStream(OutputObjectStream outputObjectStream) {
        this.out = outputObjectStream;
    }

    /*
     * Loose catch block
     */
    public void run() {
        block10: {
            block9: {
                Thread.currentThread().setName("NoThanks");
                if ("application/x-javascript".equals(this.reply.getContentType())) {
                    this.filterJavascript();
                    break block9;
                }
                this.filterHtml();
            }
            Object var2_1 = null;
            try {
                this.out.flush();
                this.out.close();
            }
            catch (IOException iOException) {}
            break block10;
            {
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    Object var2_2 = null;
                    try {
                        this.out.flush();
                        this.out.close();
                    }
                    catch (IOException iOException2) {}
                }
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                try {
                    this.out.flush();
                    this.out.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private void filterJavascript() throws IOException {
        Object object;
        Token token = new Token(5);
        while ((object = this.in.read()) != null) {
            token.append(((ByteArray)object).getBytes());
        }
        if ((token = this.factory.processScript(this.request, token)) != null) {
            this.out.write(token);
        }
    }

    private void filterHtml() throws IOException {
        Object object;
        String string = null;
        boolean bl = false;
        block5: while ((object = this.in.read()) != null) {
            Token token = (Token)object;
            if (bl && token.getType() != 4) continue;
            switch (token.getType()) {
                case 4: {
                    String string2 = token.toString();
                    bl = this.factory.killComment(string2);
                    if (bl) {
                        this.factory.report(this.request, "removed comment " + string2);
                        break;
                    }
                    if (string != null) continue block5;
                    this.out.write(token);
                    break;
                }
                case 5: {
                    token = this.factory.processScript(this.request, token);
                    if (token == null) continue block5;
                    this.out.write(token);
                    break;
                }
                case 2: {
                    Object object2;
                    boolean bl2 = true;
                    Object object3 = token.createTag();
                    if (string != null) {
                        if (!((Tag)object3).is(string)) continue block5;
                        string = null;
                        break;
                    }
                    if (this.factory.stripTag(((Tag)object3).name())) {
                        this.factory.report(this.request, "stripped " + ((Tag)object3).name());
                        string = this.factory.stripUntil(((Tag)object3).name());
                        bl2 = false;
                    }
                    if (bl2 && this.factory.replaceTag(((Tag)object3).name())) {
                        object2 = this.factory.replaceTagWith(((Tag)object3).name());
                        this.factory.report(this.request, "replaced " + ((Tag)object3).name() + " with " + ((Tag)object2).name());
                        object3 = object2;
                    }
                    if (bl2 && this.factory.checkTagAttributes((Tag)object3) && this.factory.processTagAttributes(this.request, (Tag)object3)) {
                        bl2 = false;
                        if (this.factory.hasEnd(((Tag)object3).name())) {
                            string = "/" + ((Tag)object3).name();
                        }
                    }
                    if (bl2 && this.factory.checkTag(((Tag)object3).name()) && ((Tag)object3).attributeCount() > 0) {
                        object2 = ((Tag)object3).enumerate();
                        while (object2.hasMoreElements()) {
                            String string3;
                            String string4 = (String)object2.nextElement();
                            if (!this.factory.checkAttr(string4) || (string3 = ((Tag)object3).get(string4)) == null || !this.factory.isKilled(string3)) continue;
                            if (this.factory.isRequired(((Tag)object3).name())) {
                                this.factory.report(this.request, "removed " + string4 + "=" + string3);
                                ((Tag)object3).remove(string4);
                                continue;
                            }
                            this.factory.report(this.request, "killed " + ((Tag)object3).name() + " with " + string4 + "=" + string3);
                            bl2 = false;
                            if (!this.factory.hasEnd(((Tag)object3).name())) break;
                            string = "/" + ((Tag)object3).name();
                            break;
                        }
                    }
                    if (!bl2) continue block5;
                    token.importTag((Tag)object3);
                    this.out.write(token);
                    break;
                }
                default: {
                    if (string != null) continue block5;
                    this.out.write(token);
                    break;
                }
            }
        }
    }

    public NoThanksFilter(NoThanks noThanks) {
        this.factory = noThanks;
    }
}

