/*
 * Decompiled with CFR 0.152.
 */
package org.doit.muffin.filter;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.doit.muffin.Filter;
import org.doit.muffin.FilterFactory;
import org.doit.muffin.FilterManager;
import org.doit.muffin.Prefs;
import org.doit.muffin.filter.GlossaryFilter;
import org.doit.muffin.filter.GlossaryFrame;

public class Glossary
extends Hashtable
implements FilterFactory {
    FilterManager manager;
    Prefs prefs;
    GlossaryFrame frame = null;

    public void setManager(FilterManager filterManager) {
        this.manager = filterManager;
    }

    public void setPrefs(Prefs prefs) {
        this.prefs = prefs;
        boolean bl = prefs.getOverride();
        prefs.setOverride(false);
        String string = prefs.getUserFile("glossary");
        prefs.putString("Glossary.glossaryfile", string);
        prefs.setOverride(bl);
        this.load();
    }

    public Prefs getPrefs() {
        return this.prefs;
    }

    public void viewPrefs() {
        if (this.frame == null) {
            this.frame = new GlossaryFrame(this.prefs, this);
        }
        this.frame.setVisible(true);
    }

    public Filter createFilter() {
        GlossaryFilter glossaryFilter = new GlossaryFilter(this);
        glossaryFilter.setPrefs(this.prefs);
        return glossaryFilter;
    }

    public void shutdown() {
        if (this.frame != null) {
            this.frame.dispose();
        }
    }

    void save() {
        this.manager.save(this);
    }

    String lookup(String string) {
        return (String)this.get(string.toLowerCase());
    }

    void load() {
        String string = this.prefs.getUserFile(this.prefs.getString("Glossary.glossaryfile"));
        File file = new File(string);
        if (!file.exists()) {
            System.out.println("Glossary can't open " + string);
            return;
        }
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while ((string2 = bufferedReader.readLine()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, " \t");
                String string3 = stringTokenizer.nextToken();
                String string4 = stringTokenizer.nextToken();
                this.put(string3.toLowerCase(), string4);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Glossary() {
        super(33);
    }
}

