/*
 * Decompiled with CFR 0.152.
 */
package org.doit.muffin;

import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.doit.muffin.FilterManager;
import org.doit.muffin.Handler;
import org.doit.muffin.HttpError;
import org.doit.muffin.Httpd;
import org.doit.muffin.Main;
import org.doit.muffin.Monitor;
import org.doit.muffin.Options;
import org.doit.util.ReusableThread;

class Server {
    ServerSocket server = null;
    Monitor monitor = null;
    FilterManager manager = null;
    Options options = null;
    boolean running = false;

    synchronized void suspend() {
        this.running = false;
    }

    synchronized void resume() {
        this.running = true;
    }

    void run() {
        Thread.currentThread().setName("Muffin Server");
        this.running = true;
        while (true) {
            Socket socket;
            try {
                socket = this.server.accept();
            }
            catch (IOException iOException) {
                System.out.println(iOException);
                continue;
            }
            if (!this.options.hostAccess(socket.getInetAddress())) {
                System.out.println(socket.getInetAddress().getHostAddress() + ": access denied");
                this.error(socket, 403, "No muffins for you!");
                continue;
            }
            if (this.running) {
                Handler handler = new Handler(this.monitor, this.manager, this.options, socket);
                ReusableThread reusableThread = Main.getThread();
                reusableThread.setRunnable(handler);
                continue;
            }
            this.error(socket, 503, "Muffin proxy service is suspended.");
        }
    }

    void error(Socket socket, int n, String string) {
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
            dataOutputStream.writeBytes(new HttpError(this.options, n, string).toString());
            dataOutputStream.close();
            socket.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    Server(int n, Monitor monitor, FilterManager filterManager, Options options) {
        this.manager = filterManager;
        this.options = options;
        this.monitor = monitor;
        try {
            String string = options.getString("muffin.bindaddress");
            this.server = string != null ? new ServerSocket(n, 512, InetAddress.getByName(string)) : new ServerSocket(n, 512);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            System.exit(0);
        }
        Httpd.init(options, filterManager, this.monitor, this);
    }
}

