/*
 * Decompiled with CFR 0.152.
 */
package org.doit.muffin;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.io.StringBufferInputStream;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.doit.muffin.Message;

public class Reply
extends Message {
    InputStream in = null;
    int statusCode = -1;

    public void setContent(InputStream inputStream) {
        this.in = inputStream;
    }

    public InputStream getContent() {
        return this.in;
    }

    void read() throws IOException {
        if (this.in != null) {
            this.read(this.in);
        }
    }

    void read(InputStream inputStream) throws IOException {
        this.statusLine = this.readLine(inputStream);
        if (this.statusLine == null || this.statusLine.length() == 0) {
            throw new IOException("Missing HTTP status line");
        }
        if (!this.statusLine.startsWith("HTTP")) {
            if (this.in != null) {
                String string = new String(this.statusLine + "\n");
                this.in = new SequenceInputStream(new StringBufferInputStream(string), inputStream);
            }
            this.statusLine = "HTTP/1.0 200 OK";
            return;
        }
        this.readHeaders(inputStream);
        int n = this.getStatusCode();
        switch (n) {
            case 204: 
            case 304: {
                int n2;
                if (!this.containsHeaderField("Content-length")) break;
                System.out.println("RFC 2068: Ignoring message-body from " + n + " response - " + this.getHeaderField("Server"));
                int n3 = 0;
                try {
                    n3 = Integer.parseInt(this.getHeaderField("Content-length"));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                byte[] byArray = new byte[8192];
                while ((n2 = inputStream.read(byArray, 0, byArray.length)) > 0) {
                }
                this.removeHeaderField("Content-length");
                break;
            }
        }
    }

    void write(OutputStream outputStream) throws IOException {
        String string = this.toString();
        outputStream.write(string.getBytes(), 0, string.length());
        outputStream.flush();
    }

    public boolean hasContent() {
        switch (this.getStatusCode()) {
            case 204: 
            case 304: {
                return false;
            }
        }
        return true;
    }

    public String getProtocol() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.statusLine);
        String string = stringTokenizer.nextToken();
        return string;
    }

    public int getStatusCode() {
        if (this.statusCode == -1) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.statusLine);
            String string = stringTokenizer.nextToken();
            String string2 = stringTokenizer.nextToken();
            try {
                this.statusCode = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("Malformed or missing status code");
                this.statusCode = 0;
            }
        }
        return this.statusCode;
    }

    private Hashtable headerParser(String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string2 = this.getHeaderField(string);
        if (string2 == null) {
            return hashtable;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string3;
            String string4;
            String string5 = stringTokenizer.nextToken();
            int n2 = (string5 = string5.trim()).indexOf(61);
            if (n2 != -1) {
                string4 = string5.substring(0, n2);
                string3 = string5.substring(n2 + 1);
            } else {
                string4 = string5;
                string3 = "";
            }
            if (n == 0) {
                hashtable.put(string, string4);
            } else {
                hashtable.put(string4, string3);
            }
            ++n;
        }
        return hashtable;
    }

    public String getContentType() {
        Hashtable hashtable = this.headerParser("Content-type");
        return (String)hashtable.get("Content-type");
    }

    public String getBoundary() {
        Hashtable hashtable = this.headerParser("Content-type");
        return (String)hashtable.get("boundary");
    }

    public String getTransferEncoding() {
        Hashtable hashtable = this.headerParser("Transfer-Encoding");
        return (String)hashtable.get("Transfer-Encoding");
    }

    public int getChunkSize(InputStream inputStream) throws IOException {
        String string = this.readLine(inputStream);
        string = string.trim();
        int n = -1;
        try {
            n = Integer.valueOf(string, 16);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println(numberFormatException);
        }
        return n;
    }

    public void getChunkedFooter(InputStream inputStream) throws IOException {
        int n;
        String string;
        while ((string = this.readLine(inputStream)) != null && (n = string.indexOf(58)) != -1) {
        }
    }

    public void setStatusLine(String string) {
        this.statusLine = string;
    }

    public static Reply createRedirect(String string) {
        Reply reply = new Reply();
        reply.setStatusLine("HTTP/1.0 302 Moved Temporarily");
        reply.setHeaderField("Location", string);
        return reply;
    }

    public Reply() {
    }

    public Reply(InputStream inputStream) {
        this.setContent(inputStream);
    }
}

