/*
 * Decompiled with CFR 0.152.
 */
package org.doit.muffin;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import org.doit.muffin.MuffinFrame;
import org.doit.muffin.Options;
import org.doit.util.ColorSample;

class OptionsFrame
extends MuffinFrame
implements ActionListener,
WindowListener {
    Options options;
    TextField httpProxyHost;
    TextField httpProxyPort;
    TextField httpsProxyHost;
    TextField httpsProxyPort;
    TextField hostsAllowList;
    TextField hostsDenyList;
    TextField adminAllowList;
    TextField adminDenyList;
    TextField adminUser;
    TextField adminPassword;
    TextField fg;
    TextField bg;
    TextField geometry;
    ColorSample fgSample;
    ColorSample bgSample;
    Checkbox proxyKeepAlive;
    TextField nameservers;

    void hideshow() {
        if (this.isShowing()) {
            ((Component)this).setVisible(false);
        } else {
            this.show();
        }
    }

    void sync() {
        this.options.putString("muffin.httpProxyHost", this.httpProxyHost.getText());
        this.options.putString("muffin.httpProxyPort", this.httpProxyPort.getText());
        this.options.putString("muffin.httpsProxyHost", this.httpsProxyHost.getText());
        this.options.putString("muffin.httpsProxyPort", this.httpsProxyPort.getText());
        this.options.putString("muffin.hostsAllow", this.hostsAllowList.getText());
        this.options.putString("muffin.hostsDeny", this.hostsDenyList.getText());
        this.options.putString("muffin.adminAllow", this.adminAllowList.getText());
        this.options.putString("muffin.adminDeny", this.adminDenyList.getText());
        this.options.putString("muffin.adminUser", this.adminUser.getText());
        this.options.putString("muffin.adminPassword", this.adminPassword.getText());
        this.options.putString("muffin.geometry", this.geometry.getText());
        this.options.putString("muffin.fg", this.fg.getText());
        this.options.putString("muffin.bg", this.bg.getText());
        this.fgSample.setColor(this.fg.getText());
        this.bgSample.setColor(this.bg.getText());
        MuffinFrame.getFrame("Muffin").updateGeometry(this.options.getString("muffin.geometry"));
        this.options.putBoolean("muffin.proxyKeepAlive", this.proxyKeepAlive.getState());
        this.options.putString("muffin.nameservers", this.nameservers.getText());
        this.options.sync();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("doApply".equals(string)) {
            this.sync();
            MuffinFrame.repaintFrames();
        } else if ("doSave".equals(string)) {
            this.sync();
            this.options.save();
        } else if ("doClose".equals(string)) {
            ((Component)this).setVisible(false);
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        ((Component)this).setVisible(false);
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    OptionsFrame(Options options) {
        super("Muffin: Options");
        this.options = options;
        this.setResizable(false);
        Panel panel = new Panel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        panel.setLayout(gridBagLayout);
        Label label = new Label("HTTP Proxy:", 2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagLayout.setConstraints(label, gridBagConstraints);
        panel.add(label);
        this.httpProxyHost = new TextField(20);
        this.httpProxyHost.setText(options.getString("muffin.httpProxyHost"));
        gridBagConstraints = new GridBagConstraints();
        gridBagLayout.setConstraints(this.httpProxyHost, gridBagConstraints);
        panel.add(this.httpProxyHost);
        label = new Label("Port:", 2);
        gridBagConstraints = new GridBagConstraints();
        gridBagLayout.setConstraints(label, gridBagConstraints);
        panel.add(label);
        this.httpProxyPort = new TextField(10);
        this.httpProxyPort.setText(options.getString("muffin.httpProxyPort"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.httpProxyPort, gridBagConstraints);
        panel.add(this.httpProxyPort);
        label = new Label("HTTPS Proxy:", 2);
        gridBagConstraints = new GridBagConstraints();
        gridBagLayout.setConstraints(label, gridBagConstraints);
        panel.add(label);
        this.httpsProxyHost = new TextField(20);
        this.httpsProxyHost.setText(options.getString("muffin.httpsProxyHost"));
        gridBagConstraints = new GridBagConstraints();
        gridBagLayout.setConstraints(this.httpsProxyHost, gridBagConstraints);
        panel.add(this.httpsProxyHost);
        label = new Label("Port:", 2);
        gridBagConstraints = new GridBagConstraints();
        gridBagLayout.setConstraints(label, gridBagConstraints);
        panel.add(label);
        this.httpsProxyPort = new TextField(10);
        this.httpsProxyPort.setText(options.getString("muffin.httpsProxyPort"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.httpsProxyPort, gridBagConstraints);
        panel.add(this.httpsProxyPort);
        label = new Label("HostsAllow:", 2);
        gridBagConstraints = new GridBagConstraints();
        gridBagLayout.setConstraints(label, gridBagConstraints);
        panel.add(label);
        this.hostsAllowList = new TextField(50);
        this.hostsAllowList.setText(options.getString("muffin.hostsAllow"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.hostsAllowList, gridBagConstraints);
        panel.add(this.hostsAllowList);
        label = new Label("HostsDeny:", 2);
        gridBagConstraints = new GridBagConstraints();
        gridBagLayout.setConstraints(label, gridBagConstraints);
        panel.add(label);
        this.hostsDenyList = new TextField(50);
        this.hostsDenyList.setText(options.getString("muffin.hostsDeny"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.hostsDenyList, gridBagConstraints);
        panel.add(this.hostsDenyList);
        label = new Label("AdminAllow:", 2);
        gridBagConstraints = new GridBagConstraints();
        gridBagLayout.setConstraints(label, gridBagConstraints);
        panel.add(label);
        this.adminAllowList = new TextField(50);
        this.adminAllowList.setText(options.getString("muffin.adminAllow"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.adminAllowList, gridBagConstraints);
        panel.add(this.adminAllowList);
        label = new Label("AdminDeny:", 2);
        gridBagConstraints = new GridBagConstraints();
        gridBagLayout.setConstraints(label, gridBagConstraints);
        panel.add(label);
        this.adminDenyList = new TextField(50);
        this.adminDenyList.setText(options.getString("muffin.adminDeny"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.adminDenyList, gridBagConstraints);
        panel.add(this.adminDenyList);
        label = new Label("AdminUser:", 2);
        gridBagConstraints = new GridBagConstraints();
        gridBagLayout.setConstraints(label, gridBagConstraints);
        panel.add(label);
        this.adminUser = new TextField(8);
        this.adminUser.setText(options.getString("muffin.adminUser"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.adminUser, gridBagConstraints);
        panel.add(this.adminUser);
        label = new Label("AdminPassword:", 2);
        gridBagConstraints = new GridBagConstraints();
        gridBagLayout.setConstraints(label, gridBagConstraints);
        panel.add(label);
        this.adminPassword = new TextField(8);
        this.adminPassword.setText(options.getString("muffin.adminPassword"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.adminPassword, gridBagConstraints);
        panel.add(this.adminPassword);
        label = new Label("Geometry:", 2);
        gridBagConstraints = new GridBagConstraints();
        gridBagLayout.setConstraints(label, gridBagConstraints);
        panel.add(label);
        this.geometry = new TextField(16);
        this.geometry.setText(options.getString("muffin.geometry"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.geometry, gridBagConstraints);
        panel.add(this.geometry);
        Panel panel2 = new Panel();
        label = new Label("Foreground:", 2);
        gridBagConstraints = new GridBagConstraints();
        gridBagLayout.setConstraints(label, gridBagConstraints);
        panel2.add(label);
        this.fg = new TextField(7);
        this.fg.setText(options.getString("muffin.fg"));
        this.fg.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.fg, gridBagConstraints);
        panel2.add(this.fg);
        this.fgSample = new ColorSample(options.getString("muffin.fg"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.fgSample, gridBagConstraints);
        panel2.add(this.fgSample);
        label = new Label("Background:", 2);
        gridBagConstraints = new GridBagConstraints();
        gridBagLayout.setConstraints(label, gridBagConstraints);
        panel2.add(label);
        this.bg = new TextField(7);
        this.bg.setText(options.getString("muffin.bg"));
        this.bg.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.bg, gridBagConstraints);
        panel2.add(this.bg);
        this.bgSample = new ColorSample(options.getString("muffin.bg"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.bgSample, gridBagConstraints);
        panel2.add(this.bgSample);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(panel2, gridBagConstraints);
        panel.add(panel2);
        label = new Label("Nameservers:", 2);
        gridBagConstraints = new GridBagConstraints();
        gridBagLayout.setConstraints(label, gridBagConstraints);
        panel.add(label);
        this.nameservers = new TextField(50);
        this.nameservers.setText(options.getString("muffin.nameservers"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.nameservers, gridBagConstraints);
        panel.add(this.nameservers);
        this.proxyKeepAlive = new Checkbox("Enable Proxy Keep-Alive", options.getBoolean("muffin.proxyKeepAlive"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.proxyKeepAlive, gridBagConstraints);
        panel.add(this.proxyKeepAlive);
        this.add("Center", panel);
        Panel panel3 = new Panel();
        panel3.setLayout(new GridLayout(1, 2));
        Button button = new Button("Apply");
        button.setActionCommand("doApply");
        button.addActionListener(this);
        panel3.add(button);
        button = new Button("Save");
        button.setActionCommand("doSave");
        button.addActionListener(this);
        panel3.add(button);
        button = new Button("Close");
        button.setActionCommand("doClose");
        button.addActionListener(this);
        panel3.add(button);
        this.add("South", panel3);
        this.addWindowListener(this);
        this.pack();
        ((Component)this).setSize(this.getPreferredSize());
    }
}

