/*
 * Decompiled with CFR 0.152.
 */
package org.doit.muffin;

import gnu.regexp.RE;
import gnu.regexp.REException;
import java.awt.Choice;
import java.awt.Label;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.doit.muffin.ConfFileFilter;
import org.doit.muffin.ConfigurationFrame;
import org.doit.muffin.ConfigurationListener;
import org.doit.muffin.Prefs;
import org.doit.muffin.UserPrefs;

class Configuration
extends Prefs {
    final String autoConfigFile;
    String currentConfig = null;
    String defaultConfig = null;
    Vector autoConfigPatterns = new Vector();
    Vector autoConfigNames = new Vector();
    ConfigurationFrame frame = null;
    Vector configurationListeners = new Vector();

    void addConfigurationListener(Object object) {
        this.configurationListeners.addElement(object);
        this.updateConfigurationListener(object);
    }

    synchronized void updateConfigurationListener(Object object) {
        if (object instanceof Label) {
            Label label = (Label)object;
            label.setText("Current Configuration: " + this.getCurrent());
            label.doLayout();
        } else if (object instanceof Choice) {
            Choice choice = (Choice)object;
            choice.select(this.getCurrent());
        } else if (object instanceof ConfigurationListener) {
            ConfigurationListener configurationListener = (ConfigurationListener)object;
            configurationListener.configurationChanged(this.getCurrent());
        }
    }

    void updateConfigurationListeners() {
        int n = 0;
        while (n < this.configurationListeners.size()) {
            Object e = this.configurationListeners.elementAt(n);
            this.updateConfigurationListener(e);
            ++n;
        }
    }

    void setDefault(String string) {
        this.defaultConfig = string;
    }

    String getDefault() {
        return this.defaultConfig;
    }

    synchronized void setCurrent(String string) {
        if (!string.equals(this.currentConfig)) {
            this.currentConfig = string;
            if (!this.exists(this.currentConfig)) {
                this.createConfig(this.currentConfig);
            }
            this.updateConfigurationListeners();
        }
    }

    String getCurrent() {
        return this.currentConfig;
    }

    void createConfig(String string) {
        if (!string.endsWith(".conf")) {
            string = string + ".conf";
        }
        System.out.println("Creating new configuration: " + string);
        UserPrefs userPrefs = new UserPrefs(string);
        userPrefs.setUserDirectory(this.getUserDirectory());
        this.put(string, userPrefs);
        this.updateConfigurationListeners();
    }

    UserPrefs getUserPrefs() {
        return this.getUserPrefs(this.currentConfig);
    }

    UserPrefs getUserPrefs(String string) {
        UserPrefs userPrefs = (UserPrefs)this.get(string);
        userPrefs.load();
        return userPrefs;
    }

    String autoConfig(String string) {
        int n = 0;
        while (n < this.autoConfigPatterns.size()) {
            RE rE = (RE)this.autoConfigPatterns.elementAt(n);
            if (rE.getMatch(string) != null) {
                return (String)this.autoConfigNames.elementAt(n);
            }
            ++n;
        }
        return this.defaultConfig;
    }

    String getAutoConfigFile() {
        return this.getUserFile("autoconfig");
    }

    String getUserConfigFile(String string) {
        return this.getUserFile(string);
    }

    boolean deleteUserConfigFile(String string) {
        File file = new File(this.getUserConfigFile(string));
        return file.delete();
    }

    boolean delete(String string) {
        if (string.equals(this.getDefault())) {
            System.out.println("Can't delete default configuration");
            return false;
        }
        this.remove(string);
        if (string.equals(this.getCurrent())) {
            this.setCurrent(this.getDefault());
        }
        return true;
    }

    void load(Reader reader) {
        this.autoConfigPatterns = new Vector();
        this.autoConfigNames = new Vector();
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(reader);
            while ((string = bufferedReader.readLine()) != null) {
                String string2;
                String string3;
                StringTokenizer stringTokenizer = new StringTokenizer(string, " \t");
                try {
                    string3 = stringTokenizer.nextToken();
                    string2 = stringTokenizer.nextToken();
                }
                catch (NoSuchElementException noSuchElementException) {
                    continue;
                }
                RE rE = new RE(string3);
                this.autoConfigPatterns.addElement(rE);
                this.autoConfigNames.addElement(string2);
            }
            bufferedReader.close();
        }
        catch (REException rEException) {
            System.out.println(rEException);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    void load() {
        File file = new File(this.getAutoConfigFile());
        if (!file.exists()) {
            System.out.println(file.getAbsolutePath() + " does not exist");
            return;
        }
        System.out.println("Using " + file.getAbsolutePath());
        try {
            this.load(new FileReader(file));
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    void reload() {
        this.load();
        if (this.frame != null) {
            this.frame.loadAutoConfigFile();
        }
    }

    void rescan() {
        this.clear();
        this.scan();
    }

    void scan() {
        File file = new File(this.getUserDirectory());
        if (!file.exists()) {
            return;
        }
        String[] stringArray = file.list(new ConfFileFilter());
        int n = 0;
        while (n < stringArray.length) {
            UserPrefs userPrefs = new UserPrefs(stringArray[n]);
            userPrefs.setUserDirectory(this.getUserDirectory());
            this.put(stringArray[n], userPrefs);
            ++n;
        }
    }

    void createFrame() {
        if (this.frame == null) {
            this.frame = new ConfigurationFrame(this);
        }
        this.frame.show();
    }

    Configuration() {
        this.autoConfigFile = "autoconfig";
    }
}

