/*
 * Decompiled with CFR 0.152.
 */
package UK.co.demon.asmodeus.util;

import UK.co.demon.asmodeus.util.MultiSearchResult;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class MultiSearch {
    public static String RCSID = "$Id: MultiSearch.java,v 1.1.1.1 1998/07/14 22:53:24 mrb Exp $";
    private static final boolean debug = false;
    protected String term = null;
    protected MultiSearch[] next = null;
    protected char[] charIndex = null;
    protected boolean leaf = false;
    protected int maxLength = 0;
    protected boolean isSensitive = true;

    protected void addToArray(String string, int n) {
        if (this.charIndex == null) {
            this.charIndex = new char[1];
            this.next = new MultiSearch[1];
            this.charIndex[0] = string.charAt(n);
            this.next[0] = new MultiSearch(string.substring(n + 1, string.length()));
            return;
        }
        char[] cArray = this.charIndex;
        this.charIndex = new char[cArray.length + 1];
        System.arraycopy(cArray, 0, this.charIndex, 0, cArray.length);
        this.charIndex[cArray.length] = string.charAt(n);
        MultiSearch[] multiSearchArray = this.next;
        this.next = new MultiSearch[multiSearchArray.length + 1];
        System.arraycopy(multiSearchArray, 0, this.next, 0, multiSearchArray.length);
        this.next[multiSearchArray.length] = new MultiSearch(string.substring(n + 1, string.length()));
    }

    protected void insert(String string, int n) {
        int n2;
        if (string.length() > this.maxLength) {
            this.maxLength = string.length();
        }
        if (n == string.length()) {
            return;
        }
        if (this.term != null) {
            n2 = 0;
            while (this.term.charAt(n2) == string.charAt(n)) {
                ++n2;
                if (++n == string.length()) {
                    this.leaf = true;
                    return;
                }
                if (n2 == this.term.length()) break;
            }
            if (n2 < this.term.length()) {
                MultiSearch multiSearch = new MultiSearch(this.term.substring(n2 + 1, this.term.length()));
                multiSearch.charIndex = this.charIndex;
                multiSearch.next = this.next;
                multiSearch.leaf = this.leaf;
                this.leaf = false;
                this.next = new MultiSearch[1];
                this.next[0] = multiSearch;
                this.charIndex = new char[1];
                this.charIndex[0] = this.term.charAt(n2);
                this.addToArray(string, n);
                this.term = n2 == 0 ? null : this.term.substring(0, n2);
                return;
            }
        }
        if (this.charIndex != null) {
            n2 = 0;
            while (n2 < this.charIndex.length) {
                if (string.charAt(n) == this.charIndex[n2]) {
                    this.next[n2].insert(string, n + 1);
                    return;
                }
                ++n2;
            }
            this.addToArray(string, n);
            return;
        }
        this.term = string.substring(n, string.length());
        this.leaf = true;
    }

    protected char getNextCandidate(Object object, int n) throws IOException, IndexOutOfBoundsException {
        if (n == ((String)object).length()) {
            throw new IndexOutOfBoundsException();
        }
        return ((String)object).charAt(n);
    }

    protected void backtrack(int n) {
    }

    public void dump(int n) {
        if (this.term != null) {
            System.err.print(this.term);
            n += this.term.length();
        }
        if (this.leaf) {
            System.err.print("*");
            ++n;
        }
        if (this.charIndex == null) {
            System.err.println();
            return;
        }
        int n2 = 0;
        while (n2 < this.charIndex.length) {
            if (n2 > 0) {
                System.err.print("                                          ".substring(0, n));
            }
            System.err.print("." + this.charIndex[n2]);
            this.next[n2].dump(n + 2);
            ++n2;
        }
    }

    public MultiSearchResult search(int n, Object object) throws IOException {
        MultiSearch multiSearch = this;
        int n2 = 0;
        char[] cArray = new char[this.maxLength];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (true) {
            char c;
            char c2;
            try {
                c2 = this.getNextCandidate(object, n);
                c = this.isSensitive ? c2 : Character.toLowerCase(c2);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                break;
            }
            if (multiSearch.term == null || n2 == multiSearch.term.length()) {
                if (multiSearch.leaf) {
                    if (multiSearch.charIndex == null) {
                        return new MultiSearchResult(n - n3, new String(cArray, 0, n3));
                    }
                    n5 = n2;
                    n4 = n3;
                }
            } else if (multiSearch.term != null) {
                if (multiSearch.term.charAt(n2) == c) {
                    cArray[n3++] = c2;
                    ++n2;
                    ++n;
                    continue;
                }
                this.backtrack(n3 - n4);
                n -= n3 - n4;
                n3 = n4;
                if (n3 > 0) {
                    return new MultiSearchResult(n, new String(cArray, 0, n3));
                }
                ++n;
                multiSearch = this;
                n2 = 0;
                continue;
            }
            if (multiSearch.charIndex == null) continue;
            int n6 = multiSearch.charIndex.length;
            int n7 = 0;
            while (n7 < n6) {
                if (c == multiSearch.charIndex[n7]) {
                    multiSearch = multiSearch.next[n7];
                    ++n;
                    n2 = 0;
                    cArray[n3++] = c2;
                    if (!multiSearch.leaf || multiSearch.term != null) break;
                    return new MultiSearchResult(n, new String(cArray, 0, n3));
                }
                ++n7;
            }
            if (n7 != n6) continue;
            this.backtrack(n3 - n4);
            n -= n3 - n4;
            n3 = n4;
            n2 = n5;
            if (n3 > 0) {
                return new MultiSearchResult(n, new String(cArray, 0, n3));
            }
            ++n;
            multiSearch = this;
        }
        if ((multiSearch.term == null || n2 == multiSearch.term.length()) && multiSearch.leaf) {
            if (multiSearch.charIndex == null) {
                return new MultiSearchResult(n - n3, new String(cArray, 0, n3));
            }
            n5 = n2;
            n4 = n3;
        }
        if (n4 == 0) {
            return null;
        }
        this.backtrack(n3 - n4);
        n -= n3 - n4;
        n3 = n4;
        return new MultiSearchResult(n, new String(cArray, 0, n3));
    }

    public static void main(String[] stringArray) throws IOException {
        Vector<String> vector = new Vector<String>();
        String string = "If I had a badge I mean a badger which was foo";
        vector.addElement("fooargle");
        vector.addElement("foowopple");
        vector.addElement("bADGER");
        vector.addElement("foowhip");
        vector.addElement("BADger");
        vector.addElement("foowhiq");
        vector.addElement("adge");
        vector.addElement("foo");
        MultiSearch multiSearch = new MultiSearch(vector.elements(), false);
        multiSearch.dump(0);
        MultiSearchResult multiSearchResult = new MultiSearchResult(-1, " ");
        while (multiSearchResult != null) {
            multiSearchResult = multiSearch.search(multiSearchResult.getOffset() + multiSearchResult.getMatch().length(), string);
            System.err.println(multiSearchResult);
        }
    }

    public MultiSearch() {
    }

    public MultiSearch(String string) {
        this.term = string;
        this.leaf = true;
    }

    public MultiSearch(Enumeration enumeration, boolean bl) {
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (bl) {
                this.insert(string, 0);
                continue;
            }
            this.insert(string.toLowerCase(), 0);
        }
        this.isSensitive = bl;
    }
}

