/* BigList.java */

/* 
 * Copyright (C) 1996-98 Mark Boyns <boyns@sdsu.edu>
 *
 * This file is part of Muffin.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package org.doit.muffin;

import java.awt.Dimension;
import java.awt.List;

/**
 * Create a list with fixed dimensions.
 *
 * @see java.awt.Dimension
 * @see java.awt.List
 * @author Mark Boyns
 */
public class BigList extends List
{
    int width = 200;
    int height = 150;
    
    public BigList (int rows, boolean mult)
    {
	super (rows, mult);
    }

    public void setHeight (int h)
    {
	height = h;
    }

    public void setWidth (int w)
    {
	width = w;
    }
	
    public Dimension getPreferredSize ()
    {
	return new Dimension (width, height);
    }

    public Dimension getPreferredSize (int rows)
    {
	return new Dimension (width, height);
    }

    public Dimension getMinimumSize ()
    {
	return new Dimension (width, height);
    }

    public Dimension getMinimumSize (int rows)
    {
	return new Dimension (width, height);
    }
}
