/*
 * Decompiled with CFR 0.152.
 */
package sdsu.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringBufferInputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import sdsu.util.SimpleTokenizer;
import sdsu.util.Stringizer;
import sdsu.util.TokenCharacters;

public class LabeledData
extends Properties {
    public static final String NO_VALUE = "";
    private char keyValueSeparatorChar = (char)61;
    private String pairSeparatorChars = ";";
    private boolean lowerCaseKeys = false;
    private boolean eatEscapeChar = false;
    private TokenCharacters parseTable = new TokenCharacters(String.valueOf(String.valueOf(this.keyValueSeparatorChar)) + this.pairSeparatorChars);

    public LabeledData() {
    }

    public LabeledData(Properties properties) {
        super(properties);
    }

    public Object put(String string, String string2) {
        return super.put(this.lowerCaseKeys ? string.toLowerCase() : string, string2);
    }

    public String getData(String string) {
        return this.getProperty(string);
    }

    public String getData(String string, String string2) {
        return this.getProperty(string, string2);
    }

    public void fromCommandLine(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (string.startsWith("-")) {
                if (string.equals("--")) {
                    return;
                }
                if (string.startsWith("--")) {
                    this.processSingleLetterFlag(string);
                } else if (string.indexOf(61) != -1) {
                    this.processFlagWithAssigment(string);
                } else if (n + 1 == stringArray.length) {
                    this.put(string.substring(1), NO_VALUE);
                } else {
                    String string2 = stringArray[n + 1];
                    if (string2.startsWith("-")) {
                        this.put(string.substring(1), NO_VALUE);
                    } else {
                        this.put(string.substring(1), stringArray[n + 1]);
                    }
                }
            }
            ++n;
        }
    }

    public void fromString(String string) throws IOException {
        this.load(new StringBufferInputStream(string));
    }

    public void load(InputStream inputStream) throws IOException {
        SimpleTokenizer simpleTokenizer = new SimpleTokenizer(inputStream, this.parseTable);
        simpleTokenizer.setEatEscapeChar(this.eatEscapeChar);
        while (simpleTokenizer.hasMoreTokens()) {
            String string = simpleTokenizer.nextToken();
            String string2 = simpleTokenizer.separator() == this.keyValueSeparatorChar ? simpleTokenizer.nextToken() : NO_VALUE;
            this.put(string, string2);
        }
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String string) {
        Stringizer stringizer = new Stringizer(this.parseTable);
        stringizer.setHeader(string);
        Enumeration enumeration = ((Hashtable)this).keys();
        Enumeration enumeration2 = ((Hashtable)this).elements();
        while (enumeration2.hasMoreElements()) {
            stringizer.appendToken(enumeration.nextElement(), this.keyValueSeparatorChar);
            stringizer.appendToken(enumeration2.nextElement(), this.pairSeparatorChars.charAt(0));
        }
        return stringizer.toString();
    }

    public void save(OutputStream outputStream, String string) {
        PrintStream printStream = new PrintStream(outputStream);
        printStream.println(this.toString(string));
        printStream.flush();
    }

    public void setKeyValueSeparatorChar(char c) {
        this.keyValueSeparatorChar = c;
        this.upDateParseTable();
    }

    public void setPairSeparatorChars(String string) {
        this.pairSeparatorChars = string;
        this.upDateParseTable();
    }

    public void setTokenCharacters(TokenCharacters tokenCharacters) {
        this.parseTable = tokenCharacters;
        this.upDateParseTable();
    }

    public void setLowerCaseKeys(boolean bl) {
        this.lowerCaseKeys = bl;
    }

    public void setEatEscapeChar(boolean bl) {
        this.eatEscapeChar = bl;
    }

    private void upDateParseTable() {
        this.parseTable.setSeparatorChars(String.valueOf(String.valueOf(this.keyValueSeparatorChar)) + this.pairSeparatorChars);
    }

    private void processFlagWithAssigment(String string) {
        int n = string.indexOf("=");
        this.put(string.substring(1, n), string.substring(n + 1));
    }

    private void processSingleLetterFlag(String string) {
        int n = 2;
        while (n < string.length()) {
            this.put(string.substring(n, n + 1), NO_VALUE);
            ++n;
        }
    }

    private boolean isFlag(String string) {
        return string.startsWith("-");
    }
}

