/*
 * Decompiled with CFR 0.152.
 */
package org.doit.muffin.filter;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.doit.html.Tag;
import org.doit.html.Token;
import org.doit.io.InputObjectStream;
import org.doit.io.OutputObjectStream;
import org.doit.muffin.ContentFilter;
import org.doit.muffin.Prefs;
import org.doit.muffin.Reply;
import org.doit.muffin.Request;
import org.doit.muffin.filter.StopProxy;

public class StopProxyFilter
implements ContentFilter {
    private static final String noPage = "HTTP/1.0 204 No Response";
    StopProxy factory;
    Prefs prefs;
    InputObjectStream in;
    OutputObjectStream out;
    Reply reply;

    StopProxyFilter(StopProxy stopProxy) {
        this.factory = stopProxy;
    }

    public void setPrefs(Prefs prefs) {
        this.prefs = prefs;
    }

    public boolean needsFiltration(Request request, Reply reply) {
        this.reply = reply;
        String string = reply.getContentType();
        return string != null && string.startsWith("text/html");
    }

    public void setInputObjectStream(InputObjectStream inputObjectStream) {
        this.in = inputObjectStream;
    }

    public void setOutputObjectStream(OutputObjectStream outputObjectStream) {
        this.out = outputObjectStream;
    }

    public void run() {
        Thread.currentThread().setName("StopProxy");
        try {
            Object object;
            int n = 0;
            boolean bl = true;
            String string = this.prefs.getString("StopProxy.PageTitle");
            Vector<Token> vector = new Vector<Token>();
            while ((object = this.in.read()) != null) {
                Token token = (Token)object;
                if (n >= 0 && token.getType() == 2) {
                    Tag tag = token.createTag();
                    if (tag.is("title")) {
                        n = 1;
                    } else if (tag.is("/title") || tag.is("/head")) {
                        this.dumpTokens(vector);
                        vector = null;
                        n = -1;
                    }
                    if (vector != null) {
                        vector.addElement(token);
                        continue;
                    }
                    if (!bl) continue;
                    this.out.write(token);
                    continue;
                }
                if (n > 0 && token.getType() == 3) {
                    String string2 = token.toString();
                    if (string2.startsWith(string)) {
                        this.reply.setStatusLine(noPage);
                        this.reply.removeHeaderField("Content-length");
                        this.factory.process("Page rejected - title: \"" + string2 + "\"\n");
                        bl = false;
                    } else {
                        this.dumpTokens(vector);
                    }
                    this.out.write(token);
                    vector = null;
                    n = -1;
                    continue;
                }
                if (vector != null) {
                    vector.addElement(token);
                    continue;
                }
                if (!bl) continue;
                this.out.write(token);
            }
            this.out.flush();
            this.out.close();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    private void dumpTokens(Vector vector) throws IOException {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Token token = (Token)enumeration.nextElement();
            this.out.write(token);
        }
    }
}

