/*
 * Decompiled with CFR 0.152.
 */
package org.doit.muffin.filter;

import java.awt.Dialog;
import java.awt.Window;
import java.io.ByteArrayInputStream;
import org.doit.html.Token;
import org.doit.io.ByteArray;
import org.doit.io.HtmlObjectStream;
import org.doit.io.InputObjectStream;
import org.doit.io.OutputObjectStream;
import org.doit.io.SourceObjectStream;
import org.doit.muffin.ContentFilter;
import org.doit.muffin.Prefs;
import org.doit.muffin.Reply;
import org.doit.muffin.Request;
import org.doit.muffin.filter.Preview;
import org.doit.muffin.filter.PreviewDialog;

public class PreviewFilter
implements ContentFilter {
    Preview factory;
    Prefs prefs;
    InputObjectStream in;
    OutputObjectStream out;
    Reply reply;
    Request request;

    PreviewFilter(Preview preview) {
        this.factory = preview;
    }

    public void setPrefs(Prefs prefs) {
        this.prefs = prefs;
    }

    public boolean needsFiltration(Request request, Reply reply) {
        this.request = request;
        this.reply = reply;
        String string = reply.getContentType();
        if (string == null) {
            return false;
        }
        if (this.prefs.getString("Preview.contentTypes").equals("ALL")) {
            return true;
        }
        String[] stringArray = this.prefs.getStringList("Preview.contentTypes");
        int n = 0;
        while (n < stringArray.length) {
            if (string.startsWith(stringArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void setInputObjectStream(InputObjectStream inputObjectStream) {
        this.in = inputObjectStream;
    }

    public void setOutputObjectStream(OutputObjectStream outputObjectStream) {
        this.out = outputObjectStream;
    }

    public void run() {
        Thread.currentThread().setName("Preview");
        try {
            Object object;
            Object object2;
            Object object3;
            ByteArray byteArray = new ByteArray(8192);
            boolean bl = false;
            byte[] byArray = null;
            while ((object3 = this.in.read()) != null) {
                object2 = (ByteArray)object3;
                byteArray.append((ByteArray)object2);
            }
            object2 = this.factory.previewFrame;
            synchronized (object2) {
                object = new PreviewDialog(this.factory.previewFrame, this.request, this.reply, byteArray.getBytes());
                ((Dialog)object).show();
                if (((PreviewDialog)object).accept()) {
                    byArray = ((PreviewDialog)object).getContent();
                    bl = true;
                }
                ((Window)object).dispose();
            }
            if (bl) {
                object2 = new InputObjectStream();
                SourceObjectStream sourceObjectStream = this.reply.containsHeaderField("Content-type") && this.reply.getContentType().equals("text/html") ? new HtmlObjectStream((InputObjectStream)object2) : new SourceObjectStream((InputObjectStream)object2);
                sourceObjectStream.setSourceInputStream(new ByteArrayInputStream(byArray));
                object = new Thread(sourceObjectStream);
                ((Thread)object).setName("Preview ObjectStream Source");
                ((Thread)object).start();
                while ((object3 = ((InputObjectStream)object2).read()) != null) {
                    this.out.write(object3);
                }
            } else if (this.reply.containsHeaderField("Content-type") && this.reply.getContentType().startsWith("text")) {
                object2 = new Token(3);
                ((ByteArray)object2).append("Rejected by Preview filter");
                this.out.write(object2);
            } else {
                object2 = new ByteArray();
                ((ByteArray)object2).append((byte)0);
                this.out.write(object2);
            }
            this.out.flush();
            this.out.close();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }
}

